<?php
/**
 * Check AMF Library Installation
 */

use SabreAMF\AMF; // <-- Pindahkan ke sini

echo "<h2>AMF Gateway Check</h2>";

// Check SabreAMF
echo "<h3>1. SabreAMF Check</h3>";
if (file_exists(__DIR__ . '/vendor/autoload.php')) {
    echo "✅ vendor/autoload.php exists<br>";
    
    try {
        require_once __DIR__ . '/vendor/autoload.php';
        echo "✅ SabreAMF classes can be loaded<br>";
    } catch (Exception $e) {
        echo "❌ Error loading SabreAMF: " . $e->getMessage() . "<br>";
    }
}
 else {
    echo "❌ vendor/autoload.php NOT found<br>";
    echo "Install with: composer require sabre/amf<br>";
}

// Check AMFPHP
echo "<h3>2. AMFPHP Check</h3>";
if (file_exists(__DIR__ . '/../amfphp/gateway.php')) {
    echo "✅ AMFPHP gateway.php exists<br>";
} else {
    echo "❌ AMFPHP NOT found<br>";
    echo "Download from: https://github.com/neoxic/amfphp<br>";
}

// Check current index.php
echo "<h3>3. Current Gateway</h3>";
if (file_exists(__DIR__ . '/index.php')) {
    $content = file_get_contents(__DIR__ . '/index.php');
    if (strpos($content, 'vendor/autoload.php') !== false) {
        echo "✅ Using SabreAMF version<br>";
    } elseif (strpos($content, 'amfphp') !== false) {
        echo "✅ Using AMFPHP version<br>";
    } else {
        echo "⚠️ Using JSON version (not AMF)<br>";
    }
} else {
    echo "❌ index.php NOT found<br>";
}

// Check services
echo "<h3>4. Services Check</h3>";
$services = ['SystemService.php', 'CharacterDAO.php', 'SystemData.php'];
foreach ($services as $service) {
    if (file_exists(__DIR__ . '/services/' . $service)) {
        echo "✅ $service exists<br>";
    } else {
        echo "❌ $service NOT found<br>";
    }
}

// Check database
echo "<h3>5. Database Check</h3>";
try {
    require_once __DIR__ . '/config.php';
    require_once __DIR__ . '/db.php';
    $db = getDBConnection();
    echo "✅ Database connection OK<br>";
    
    $stmt = $db->query("SELECT COUNT(*) FROM accounts");
    $count = $stmt->fetchColumn();
    echo "✅ Accounts in database: $count<br>";
} catch (Exception $e) {
    echo "❌ Database error: " . $e->getMessage() . "<br>";
}

echo "<hr>";
echo "<h3>Recommendation</h3>";
echo "For best compatibility with ZendAMF client, use AMFPHP instead of SabreAMF.<br>";
echo "Download: <a href='https://github.com/neoxic/amfphp'>https://github.com/neoxic/amfphp</a><br>";
?>

