<?php
error_reporting(0);

require_once __DIR__ . '/config.php';
require_once __DIR__ . '/db.php';

require_once __DIR__ . '/vendor/SabreAMF/Message.php';
require_once __DIR__ . '/vendor/SabreAMF/InputStream.php';
require_once __DIR__ . '/vendor/SabreAMF/OutputStream.php';
require_once __DIR__ . '/vendor/SabreAMF/AMF0/Deserializer.php';
require_once __DIR__ . '/vendor/SabreAMF/AMF0/Serializer.php';

require_once __DIR__ . '/services/SystemService.php';
require_once __DIR__ . '/services/CharacterDAO.php';
require_once __DIR__ . '/services/SystemData.php';

class Gateway {

    public function callService($service, $method, $params) {
        $allowed = [
            'SystemService',
            'CharacterDAO',
            'SystemData'
        ];

        if (!in_array($service, $allowed)) {
            throw new Exception("Unknown Service: " . $service);
        }

        $db = getDBConnection();
        $obj = new $service($db);

        if (!method_exists($obj, $method)) {
            throw new Exception("Unknown Method: " . $method);
        }

        return call_user_func_array([$obj, $method], $params);
    }

}

// Debug ON
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/error.log');

function sendError($msg) {
    header("Content-Type: application/x-amf");

    $resp = new SabreAMF_Message();
    $body = [
        'target' => null,
        'response' => '/onStatus',
        'data' => [
            'status' => 0,
            'error' => $msg
        ]
    ];
    $resp->addBody($body);

    $out = new SabreAMF_OutputStream();
    $resp->serialize($out);

    echo $out->getRawData();
    exit;
}

try {

    
    $raw = file_get_contents("php://input");
    file_put_contents(__DIR__ . "/debug_raw.log", $raw);

    if (!$raw || strlen($raw) < 1) sendError("Empty Request");

    $input = new SabreAMF_InputStream($raw);
    $msg = new SabreAMF_Message();
    $msg->deserialize($input);
    file_put_contents(__DIR__ . "/debug_msg.log", print_r($msg, true));


    $body = $msg->getBodies()[0];
    $target = $body['target'];
    $response = $body['response'];
    $data = $body['data'];

    $parts = explode(".", $target);
    $service = $parts[0];
    $method = $parts[1];

    if (!is_array($data)) $data = [$data];

    $gateway = new Gateway();
    $result = $gateway->callService($service, $method, $data);

    $responseObj = new stdClass();
    $responseObj->status = 1;
    $responseObj->result = $result;

    $resp = new SabreAMF_Message();
    $resp->addBody([
        'target' => "",
        'response' => $response . "/onResult",
        'data' => $responseObj
    ]);

    $out = new SabreAMF_OutputStream();
    $resp->serialize($out);

    header("Content-Type: application/x-amf");
    echo $out->getRawData();
    exit;

} catch (Exception $e) {
    sendError($e->getMessage());
}
