<?php


// Debug semua request AMF
$raw = file_get_contents('php://input');
file_put_contents(__DIR__.'/amf_call.log',
    date('c').' len='.strlen($raw).' ua='.($_SERVER['HTTP_USER_AGENT'] ?? '').
    ' uri='.$_SERVER['REQUEST_URI']."\n",
    FILE_APPEND);

// lanjutkan kode gateway yang lama...
    
file_put_contents(__DIR__ . "/debug_trace.log",
    "RUN " . date('c') . " METHOD=" . (isset($_SERVER['REQUEST_METHOD']) ? $_SERVER['REQUEST_METHOD'] : 'CLI') . "\n",
    FILE_APPEND
);
// tulis juga targetURI / body count dsb.
// error_reporting(0);

require_once __DIR__ . '/config.php';
require_once __DIR__ . '/db.php';

// pakai autoloader Composer untuk SabreAMF
require_once __DIR__ . '/vendor/autoload.php';
// require_once __DIR__ . '/vendor/SabreAMF/Message.php';
// require_once __DIR__ . '/vendor/SabreAMF/InputStream.php';
// require_once __DIR__ . '/vendor/SabreAMF/OutputStream.php';
// require_once __DIR__ . '/vendor/SabreAMF/AMF0/Deserializer.php';
// require_once __DIR__ . '/vendor/SabreAMF/AMF0/Serializer.php';

require_once __DIR__ . '/services/SystemService.php';
require_once __DIR__ . '/services/CharacterDAO.php';
require_once __DIR__ . '/services/SystemData.php';
require_once __DIR__ . '/services/PetService.php';
require_once __DIR__ . '/services/BattleSystem.php';

class Gateway {

    public function callService($service, $method, $params) {
        $allowed = [
            'SystemService',
            'CharacterDAO',
            'SystemData',
            'PetService',
            'BattleSystem',
            'EventsService',
        ];

        if (!in_array($service, $allowed)) {
            throw new Exception("Unknown Service: " . $service);
        }

        $db = getDBConnection();
        $obj = new $service($db);

        if (!method_exists($obj, $method)) {
            throw new Exception("Unknown Method: " . $method);
        }

        return call_user_func_array([$obj, $method], $params);
    }

}

function ns_generate_login_signature(array $accountArray) {
    // $accountArray: [account_id, account_type, balance, session_key]
    $sessionKey     = isset($accountArray[3]) ? (string)$accountArray[3] : '';
    $accountId      = isset($accountArray[0]) ? (int)$accountArray[0] : 0;
    $accountType    = isset($accountArray[1]) ? (int)$accountArray[1] : 0;
    $accountBalance = isset($accountArray[2]) ? (int)$accountArray[2] : 0;

    // Sama dengan ClientLibrary._s di ClientLibrary.as
    $secret = 'Vmn34aAciYK00Hen26nT01';

    // _loc3_ = param1[0] + "|" + param1[1] + "|" + param1[2];
    $str = $accountId . '|' . $accountType . '|' . $accountBalance;

    // base = str + _s + sessionKey;
    $base = $str . $secret . $sessionKey;

    // sha1 sebagai hex string
    $sha1 = sha1($base);

    // offset = parseInt("0x" + sessionKey.substr(1,1),16)
    $offset = 0;
    if (strlen($sessionKey) > 1) {
        $hexChar = substr($sessionKey, 1, 1);
        if (ctype_xdigit($hexChar)) {
            $offset = hexdec($hexChar);
        }
    }

    return substr($sha1, $offset, 12);
}

function ns_get_class_skill_map() {
    static $map = null;
    if ($map === null) {
        $map = array(
            1 => 'skill_4002',
            2 => 'skill_4004',
            3 => 'skill_4001',
            4 => 'skill_4003',
            5 => 'skill_4000',
        );
    }
    return $map;
}

function ns_class_code_to_skill($code) {
    $map = ns_get_class_skill_map();
    $code = (int)$code;
    if ($code === 0) {
        // Konsisten dengan perilaku lama: karakter tanpa class tersimpan sebagai "0" string
        return '0';
    }
    return isset($map[$code]) ? $map[$code] : null;
}

function ns_skill_to_class_code($skill) {
    if ($skill === null || $skill === '' || $skill === '0') {
        return 0;
    }
    $map = ns_get_class_skill_map();
    $reverse = array_flip($map);
    return isset($reverse[$skill]) ? (int)$reverse[$skill] : 0;
}

// Debug ON (log ke file saja, jangan tampilkan di output supaya AMF tidak rusak)
error_reporting(E_ALL);
ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/error.log');

// Tangkap fatal error yang tidak tertangkap try/catch (misalnya Error PHP7)
if (!function_exists('ns_amf_shutdown_logger')) {
    function ns_amf_shutdown_logger() {
        $err = error_get_last();
        if ($err && in_array($err['type'], array(E_ERROR, E_PARSE, E_CORE_ERROR, E_COMPILE_ERROR))) {
            file_put_contents(__DIR__ . '/debug_trace.log',
                "FATAL_SHUTDOWN type={$err['type']} message={$err['message']} file={$err['file']} line={$err['line']}\n",
                FILE_APPEND
            );
        }
    }
    register_shutdown_function('ns_amf_shutdown_logger');
}

function sendError($msg) {
    // Pastikan tidak ada output lain (HTML, notice) sebelum AMF
    if (function_exists('ob_get_length') && ob_get_length()) {
        @ob_clean();
    }

    $resp = new SabreAMF_Message();
    $body = array(
        'target'   => '/onStatus',
        'response' => '',
        'data'     => array(
            'status' => 0,
            'error'  => $msg,
        ),
    );
    $resp->addBody($body);

    file_put_contents(__DIR__ . "/debug_trace.log",
        "BEFORE SERIALIZE (sendError)\n",
        FILE_APPEND
    );

    $out = new SabreAMF_OutputStream();
    $resp->serialize($out);

    file_put_contents(__DIR__ . "/debug_trace.log",
        "AFTER SERIALIZE (sendError)\n",
        FILE_APPEND
    );

    header("Content-Type: application/x-amf");
    echo $out->getRawData();

    file_put_contents(__DIR__ . "/debug_trace.log",
        "AFTER ECHO (sendError)\n",
        FILE_APPEND
    );
    exit;
}

try {

    file_put_contents(__DIR__ . "/debug_trace.log",
        "BEFORE INPUT\n",
        FILE_APPEND
    );

    // $raw sudah dibaca sekali di atas (untuk amf_call.log), pakai ulang di sini
    file_put_contents(__DIR__ . "/debug_trace.log",
        "AFTER INPUT len=" . strlen($raw) . " POST=" . json_encode($_POST) . "\n",
        FILE_APPEND
    );
    file_put_contents(__DIR__ . "/debug_raw.log", $raw);

    file_put_contents(__DIR__ . "/debug_trace.log",
    "BEFORE NEW INPUTSTREAM\n",
    FILE_APPEND
);
$input = new SabreAMF_InputStream($raw);
file_put_contents(__DIR__ . "/debug_trace.log",
    "AFTER NEW INPUTSTREAM\n",
    FILE_APPEND
);
$msg = new SabreAMF_Message();
file_put_contents(__DIR__ . "/debug_trace.log",
    "AFTER NEW MESSAGE\n",
    FILE_APPEND
);
$msg->deserialize($input);
file_put_contents(__DIR__ . "/debug_trace.log",
    "AFTER DESERIALIZE OK bodies=" . count($msg->getBodies()) . "\n",
    FILE_APPEND
);

    if (!$raw || strlen($raw) < 1) sendError("Empty Request");

    file_put_contents(__DIR__ . "/debug_trace.log",
    "INCLUDED_FILES:\n" . var_export(get_included_files(), true) . "\n",
    FILE_APPEND
);
    $input = new SabreAMF_InputStream($raw);
    $msg = new SabreAMF_Message();
    $msg->deserialize($input);

    file_put_contents(__DIR__ . "/debug_trace.log",
        "AFTER DESERIALIZE OK bodies=" . count($msg->getBodies()) . "\n",
        FILE_APPEND
    );

    file_put_contents(__DIR__ . "/debug_msg.log", print_r($msg, true));


    $body = $msg->getBodies()[0];
    $target = $body['target'];
    $response = $body['response'];
    $data = $body['data'];

    $parts = explode(".", $target);
    $service = $parts[0];
    $method = $parts[1];

    if (!is_array($data)) $data = [$data];

    $responseObj = new stdClass();

    if ($service === 'SystemLogin' && $method === 'checkVersion') {

        $responseObj->status = 1;
        $responseObj->_ = 1;
        $responseObj->__ = 'ns_key';
        // Arahkan semua asset (items, swf, dll) ke server sendiri
        $responseObj->cdn = 'https://aimer.man1langkat.sch.id/';
        $responseObj->_rm = 0;

        file_put_contents(
            __DIR__ . "/debug_result.log",
            "SERVICE={$service} METHOD={$method}\n" . print_r($responseObj, true) . "\n",
            FILE_APPEND
        );

    } elseif ($service === 'SystemLogin' && $method === 'loginUser') {

        $gateway = new Gateway();

        $username = isset($data[0]) ? $data[0] : '';
        $encryptedPassword = isset($data[1]) ? $data[1] : '';
        $buildNo = '3.3.00810';

        $loginData = $gateway->callService('SystemService', 'login', array($username, $encryptedPassword, $buildNo));

        $accountArray = isset($loginData['account']) ? $loginData['account'] : array(0, 0, 0, '');

        $responseObj->status = 1;
        $responseObj->__ = 'ns_key';
        $responseObj->uid = $accountArray[0];
        $responseObj->sessionkey = $accountArray[3];

        $responseObj->events = array();
        $responseObj->clan_season = 0;
        $responseObj->crew_season = 0;
        $responseObj->sw_season = 0;
        $responseObj->banners = array();

        file_put_contents(__DIR__ . "/debug_result.log", print_r($responseObj, true));

    } elseif ($service === 'SystemLogin' && $method === 'getAllCharacters') {

        $sessionKey = isset($data[1]) ? $data[1] : '';

        // Ambil informasi akun dari session untuk menentukan account_type.
        // Nilai tokens diambil dari kolom character_token pada tabel characters.
        $accountType     = 0;
        $tokens          = 0;
        $emblemDuration  = 0;
        $accountInfo     = validateSessionKey($sessionKey);
        if ($accountInfo && is_array($accountInfo)) {
            if (isset($accountInfo['account_type'])) {
                // Dari DB: 0 = Free, 1 = Premium
                $accountType = (int)$accountInfo['account_type'];
            }

            // Hitung total token dari semua karakter di akun ini
            try {
                $dbTok = getDBConnection();
                $stmtTok = $dbTok->prepare("
                    SELECT SUM(character_token) AS tokens
                    FROM characters
                    WHERE account_id = ?
                ");
                $stmtTok->execute(array($accountInfo['account_id']));
                $rowTok = $stmtTok->fetch(PDO::FETCH_ASSOC);
                if ($rowTok && $rowTok['tokens'] !== null) {
                    $tokens = (int)$rowTok['tokens'];
                }
            } catch (Exception $e) {
                // Jika query token gagal, biarkan tokens = 0 agar tidak menggagalkan login
                $tokens = 0;
            }

            // emblemDuration tetap 0 untuk sekarang (belum ada kolom di DB)
        }

        $gateway = new Gateway();
        $result = $gateway->callService('CharacterDAO', 'getCharactersList', array($sessionKey));

        $accountData = array();
        if (is_array($result)) {
            foreach ($result as $row) {
                $char = new stdClass();
                $char->char_id          = isset($row['character_id'])   ? (int)$row['character_id']   : 0;
                $char->character_name   = isset($row['character_name']) ? (string)$row['character_name'] : '';
                $char->character_level  = isset($row['character_level'])? (int)$row['character_level'] : 1;
                $char->character_xp     = isset($row['character_xp'])   ? (int)$row['character_xp']   : 0;
                $char->character_gender = isset($row['character_gender']) ? (int)$row['character_gender'] : 0;
                $char->character_rank   = isset($row['character_rank'])   ? (int)$row['character_rank']   : 0;
                $codeClass              = isset($row['character_class']) ? (int)$row['character_class'] : 0;
                $char->character_class  = ns_class_code_to_skill($codeClass);

                // Derive up to 3 elements from stat fields character_wind/fire/lightning/water/earth
                $elements  = array();
                $elemStats = array(
                    1 => isset($row['character_wind'])      ? (int)$row['character_wind']      : 0,
                    2 => isset($row['character_fire'])      ? (int)$row['character_fire']      : 0,
                    3 => isset($row['character_lightning']) ? (int)$row['character_lightning'] : 0,
                    4 => isset($row['character_earth'])     ? (int)$row['character_earth']     : 0,
                    5 => isset($row['character_water'])     ? (int)$row['character_water']     : 0,
                );

                foreach ($elemStats as $idx => $val) {
                    if ($val > 0) {
                        $elements[] = $idx;
                    }
                }

                $char->character_element_1 = isset($elements[0]) ? $elements[0] : 0;
                $char->character_element_2 = isset($elements[1]) ? $elements[1] : 0;
                $char->character_element_3 = isset($elements[2]) ? $elements[2] : 0;

                // When a character has no talent learned yet, client code expects
                // character_talent_1/2/3 to be null, not 0. Using 0 makes
                // TalentPanel.initMovieClips() think a talent exists and then
                // call fillUP() with an invalid id, causing Error #1010.
                $talent1 = null;
                $talent2 = null;
                $talent3 = null;

                if (isset($row['character_skill_talent']) && $row['character_skill_talent'] !== null && $row['character_skill_talent'] !== '') {
                    $talRaw = json_decode($row['character_skill_talent'], true);
                    if (is_array($talRaw)) {
                        foreach ($talRaw as $entry) {
                            if (!is_array($entry)) {
                                continue;
                            }
                            if (!isset($entry['kind']) || $entry['kind'] !== 'tree') {
                                continue;
                            }
                            $slot     = isset($entry['slot']) ? (int)$entry['slot'] : 0;
                            $talentId = isset($entry['talent_id']) ? (string)$entry['talent_id'] : '';
                            if ($talentId === '') {
                                continue;
                            }
                            if ($slot === 1) {
                                $talent1 = $talentId;
                            } elseif ($slot === 2) {
                                $talent2 = $talentId;
                            } elseif ($slot === 3) {
                                $talent3 = $talentId;
                            }
                        }
                    }
                }

                $char->character_talent_1  = $talent1;
                $char->character_talent_2  = $talent2;
                $char->character_talent_3  = $talent3;
                $char->character_gold      = isset($row['character_gold']) ? (int)$row['character_gold'] : 0;
                $char->character_tp        = isset($row['character_tp']) ? (int)$row['character_tp'] : 0;
                $char->character_prestige  = 0;

                $accountData[] = $char;
            }
        }

        $responseObj->status           = 1;
        $responseObj->total_characters = count($accountData);
        $responseObj->account_type     = $accountType;
        $responseObj->tokens           = $tokens;
        $responseObj->emblem_duration  = $emblemDuration;
        $responseObj->account_data     = $accountData;

        file_put_contents(
            __DIR__ . "/debug_result.log",
            "SERVICE={$service} METHOD={$method}\n" . print_r($responseObj, true) . "\n",
            FILE_APPEND
        );

    } elseif ($service === 'SystemLogin' && $method === 'getCharacterData') {

        // param: [0] = char_id, [1] = sessionKey
        $charId     = isset($data[0]) ? (int)$data[0] : 0;
        $sessionKey = isset($data[1]) ? (string)$data[1] : '';

        $db = getDBConnection();
        $charDao = new CharacterDAO($db);

        try {
            $character = $charDao->getCharacterById($sessionKey, $charId);

            // --- derive elements from attribute stats ---
            $elemStats = array(
                1 => isset($character['character_wind'])      ? (int)$character['character_wind']      : 0,
                2 => isset($character['character_fire'])      ? (int)$character['character_fire']      : 0,
                3 => isset($character['character_lightning']) ? (int)$character['character_lightning'] : 0,
                4 => isset($character['character_earth'])     ? (int)$character['character_earth']     : 0,
                5 => isset($character['character_water'])     ? (int)$character['character_water']     : 0,
            );
            $elements = array();
            foreach ($elemStats as $idx => $val) {
                if ($val > 0) {
                    $elements[] = $idx;
                }
            }

            // simpan ke array karakter sebagai compatibility
            $character['character_element_1'] = isset($elements[0]) ? $elements[0] : 0;
            $character['character_element_2'] = isset($elements[1]) ? $elements[1] : 0;
            $character['character_element_3'] = isset($elements[2]) ? $elements[2] : 0;

            // --- character_sets ---
            $characterSets = new stdClass();

            // Gender dipakai untuk default asset (0 = male, 1 = female)
            $gender = isset($character['character_gender']) ? (int)$character['character_gender'] : 0;

            // Weapon ID: normalisasi dari "wpn1" -> "wpn_01" dan set default kalau kosong
            $weaponId = '';
            if (!empty($character['character_equipped_weapon'])) {
                $weaponId = (string)$character['character_equipped_weapon'];
                if (preg_match('/^wpn(\d+)$/', $weaponId, $m)) {
                    $weaponId = 'wpn_' . str_pad($m[1], 2, '0', STR_PAD_LEFT);
                }
            }
            if ($weaponId === '') {
                $weaponId = 'wpn_01';
            }
            $characterSets->weapon = $weaponId;

            // Back item: normalisasi dari "back1" -> "back_01" dan default ke back_01 kalau kosong
            $backId = '';
            if (!empty($character['character_equipped_back_item'])) {
                $backId = (string)$character['character_equipped_back_item'];
                if (preg_match('/^back(\d+)$/', $backId, $m)) {
                    $backId = 'back_' . str_pad($m[1], 2, '0', STR_PAD_LEFT);
                }
            }
            if ($backId === '') {
                $backId = 'back_01';
            }
            $characterSets->back_item = $backId;

            // Accessory: ambil dari kolom equipped kalau ada, kalau tidak coba dari JSON character_body_parts->accessory
            $accessoryId = '';
            if (!empty($character['character_equipped_accessory'])) {
                $accessoryId = (string)$character['character_equipped_accessory'];
            } elseif (!empty($character['character_body_parts']) && is_array($character['character_body_parts']) && !empty($character['character_body_parts']['accessory'])) {
                $accessoryId = (string)$character['character_body_parts']['accessory'];
            }
            $characterSets->accessory = $accessoryId;

            // Set / clothing: gunakan character_body_set kalau ada, kalau kosong pakai set dasar sesuai gender
            $setId = '';
            if (!empty($character['character_body_set'])) {
                $setId = (string)$character['character_body_set'];
            }

            // Normalisasi data lama "set1", "set2", dst -> "set_01_gender", "set_02_gender"
            if ($setId !== '' && preg_match('/^set(\d+)$/', $setId, $mSet)) {
                $num   = (int)$mSet[1];
                $setId = 'set_' . str_pad($num, 2, '0', STR_PAD_LEFT) . '_' . $gender;
            } elseif ($setId !== '' && preg_match('/^set_(\d+)_([01])$/', $setId, $mSet2)) {
                // Data sudah dalam format baru tetapi suffix gender bisa saja tidak sesuai,
                // paksa suffix agar selalu sama dengan character_gender
                $num   = (int)$mSet2[1];
                $setId = 'set_' . str_pad($num, 2, '0', STR_PAD_LEFT) . '_' . $gender;
            }

            if ($setId === '') {
                $setId = 'set_01_' . $gender;
            }
            $characterSets->clothing = $setId;

            // Hairstyle: perbaiki data lama "2_0" -> "hair_02_0".
            $hairId = '';
            if (!empty($character['character_hair'])) {
                $hairId = (string)$character['character_hair'];
                if (preg_match('/^(\d+)_([01])$/', $hairId, $mHair)) {
                    $hairNum    = (int)$mHair[1];
                    $hairGender = $mHair[2];
                    $hairId = 'hair_' . str_pad($hairNum, 2, '0', STR_PAD_LEFT) . '_' . $hairGender;
                }
            } elseif (!empty($character['character_face']) && preg_match('/^(\d+)_([01])$/', (string)$character['character_face'], $mHairFromFace)) {
                // Beberapa karakter lama menyimpan index rambut di kolom face
                $hairNum    = (int)$mHairFromFace[1];
                $hairGender = $mHairFromFace[2];
                $hairId = 'hair_' . str_pad($hairNum, 2, '0', STR_PAD_LEFT) . '_' . $hairGender;
            } else {
                $hairId = 'hair_01_' . $gender;
            }
            $characterSets->hairstyle = $hairId;

            // Skills yang sedang dipakai:
            // 1) gunakan kolom character_equipped_skills bila ada
            // 2) jika kosong, coba ambil dari inventory.skillsets[0].skills
            $equippedSkills = '';
            if (!empty($character['character_equipped_skills'])) {
                $equippedSkills = (string)$character['character_equipped_skills'];
            } elseif (
                isset($character['character_inventory']) &&
                is_array($character['character_inventory']) &&
                isset($character['character_inventory']['skillsets']) &&
                is_array($character['character_inventory']['skillsets']) &&
                !empty($character['character_inventory']['skillsets'])
            ) {
                $firstSet = $character['character_inventory']['skillsets'][0];
                if (is_array($firstSet) && isset($firstSet['skills'])) {
                    $equippedSkills = (string)$firstSet['skills'];
                } elseif (is_object($firstSet) && isset($firstSet->skills)) {
                    $equippedSkills = (string)$firstSet->skills;
                }
            }
            $characterSets->skills = $equippedSkills;

            // Hair color sebagai string "a|b" (contoh: "123456|654321") atau default "0|0"
            if (isset($character['character_hair_color'])) {
                $hairColor = $character['character_hair_color'];

                // Jika tersimpan sebagai JSON string "[a,b]", decode dulu
                if (is_string($hairColor) && strlen($hairColor) > 0 && $hairColor[0] === '[') {
                    $decoded = json_decode($hairColor, true);
                    if (is_array($decoded)) {
                        $hairColor = $decoded;
                    }
                }

                if (is_array($hairColor)) {
                    $characterSets->hair_color = implode('|', $hairColor);
                } else {
                    $characterSets->hair_color = (string)$hairColor;
                }
            } else {
                $characterSets->hair_color = '0|0';
            }

            // Skin color: gunakan nilai dari DB (character_skin_color) jika ada.
            // Format yang dipakai client: "a|b" atau "null|null".
            if (isset($character['character_skin_color'])) {
                $skinColor = (string)$character['character_skin_color'];

                // Data lama 0 atau "0|0" dianggap tidak ada override warna
                if ($skinColor === '' || $skinColor === '0' || $skinColor === '0|0') {
                    $skinColor = 'null|null';
                }

                $characterSets->skin_color = $skinColor;
            } else {
                // Default: tidak ada color transform, pakai warna asli dari SWF
                $characterSets->skin_color = 'null|null';
            }

            // Face: normalisasi data lama seperti "17_0" menjadi face dasar "face_01_0"
            $faceId = isset($character['character_face']) ? (string)$character['character_face'] : '';
            if ($faceId === '' || preg_match('/^(\d+)_([01])$/', $faceId)) {
                $faceId = 'face_01_' . $gender;
            }
            $characterSets->face = $faceId;

            $characterSets->senjutsu_skills = '';
            $characterSets->anims = new stdClass();

            // --- character_inventory ---
            // Ambil dari kolom character_inventory (JSON) jika ada, kalau kosong isi minimal dengan gear yang sedang dipakai
            $characterInventory = new stdClass();
            $inv = array();
            if (isset($character['character_inventory']) && is_array($character['character_inventory'])) {
                $inv = $character['character_inventory'];
            }

            $characterInventory->char_weapons         = !empty($inv['char_weapons'])         ? $inv['char_weapons']         : ($weaponId !== '' ? $weaponId . ':1' : '');
            $characterInventory->char_back_items      = !empty($inv['char_back_items'])      ? $inv['char_back_items']      : ($backId !== ''   ? $backId   . ':1' : '');
            $characterInventory->char_accessories     = !empty($inv['char_accessories'])     ? $inv['char_accessories']     : '';
            $characterInventory->char_sets            = !empty($inv['char_sets'])            ? $inv['char_sets']            : ($setId   !== '' ? $setId   . ':1' : '');
            $characterInventory->char_hairs           = !empty($inv['char_hairs'])           ? $inv['char_hairs']           : ($hairId  !== '' ? $hairId  . ':1' : '');
            $characterInventory->char_skills          = !empty($inv['char_skills'])          ? $inv['char_skills']          : '';

            // Sinkronisasi talent battle: jika inventory belum punya char_talent_skills,
            // bangun dari struktur character_skill_talent (sudah didecode jadi array di CharacterDAO).
            $charTalentSkills = !empty($inv['char_talent_skills']) ? (string)$inv['char_talent_skills'] : '';
            if ($charTalentSkills === '' && !empty($character['character_skill_talent']) && is_array($character['character_skill_talent'])) {
                $skillLevels = array(); // skill_id => level
                foreach ($character['character_skill_talent'] as $entry) {
                    if (!is_array($entry) || !isset($entry['kind']) || $entry['kind'] !== 'skill') {
                        continue;
                    }
                    $sid = isset($entry['skill_id']) ? (string)$entry['skill_id'] : '';
                    $lvl = isset($entry['level']) ? (int)$entry['level'] : 0;
                    if ($sid === '' || $lvl <= 0) {
                        continue;
                    }
                    // Jika duplikat muncul, ambil level terakhir
                    $skillLevels[$sid] = $lvl;
                }
                if (!empty($skillLevels)) {
                    $pieces = array();
                    foreach ($skillLevels as $sid => $lvl) {
                        $pieces[] = $sid . ':' . $lvl;
                    }
                    $charTalentSkills = implode(',', $pieces);
                }
            }
            $characterInventory->char_talent_skills   = $charTalentSkills;

            $characterInventory->char_senjutsu_skills = !empty($inv['char_senjutsu_skills']) ? $inv['char_senjutsu_skills'] : '';
            $characterInventory->char_materials       = !empty($inv['char_materials'])       ? $inv['char_materials']       : '';
            $characterInventory->char_essentials      = !empty($inv['char_essentials'])      ? $inv['char_essentials']      : '';
            $characterInventory->char_items           = !empty($inv['char_items'])           ? $inv['char_items']           : '';
            $characterInventory->char_animations      = !empty($inv['char_animations'])      ? $inv['char_animations']      : '';

            // --- character_slots ---
            $characterSlots = new stdClass();
            $characterSlots->weapons    = 1;
            $characterSlots->back_items = 1;
            $characterSlots->accessories= 1;
            $characterSlots->hairstyles = 1;
            $characterSlots->clothing   = 1;

            // --- character_points ---
            // Ambil dari field karakter di DB agar poin atribut tersimpan permanen
            $characterPoints = new stdClass();
            $characterPoints->atrrib_wind      = isset($character['character_wind'])      ? (int)$character['character_wind']      : 0;
            $characterPoints->atrrib_fire      = isset($character['character_fire'])      ? (int)$character['character_fire']      : 0;
            $characterPoints->atrrib_lightning = isset($character['character_lightning']) ? (int)$character['character_lightning'] : 0;
            $characterPoints->atrrib_water     = isset($character['character_water'])     ? (int)$character['character_water']     : 0;
            $characterPoints->atrrib_earth     = isset($character['character_earth'])     ? (int)$character['character_earth']     : 0;

            // Client akan hitung ulang free points berdasarkan level dan total di atas
            $characterPoints->atrrib_free      = 0;

            // --- events ---
            $events = new stdClass();
            $events->welcome_bonus = 0;

            // --- pet_data --- (equip pet dari DB jika ada)
            $petData = new stdClass();
            if (!empty($character['character_pet'])) {
                $petData->pet_id   = isset($character['character_pet_id']) ? (int)$character['character_pet_id'] : 0;
                $petData->pet_swf  = (string)$character['character_pet'];
                $petData->pet_name = (string)$character['character_pet'];

                // Statistik dasar agar UI & battle tidak error
                $petData->pet_level  = 1;
                $petData->pet_xp     = 0;
                $petData->pet_mp     = 100;
                $petData->pet_skills = '0,0,0,0,0,0';
            }

            // --- character_data minimal ---
            $charData = new stdClass();

            $charData->character_class = null;
            $dbClassCode = isset($character['character_class']) ? (int)$character['character_class'] : 0;
            $dbClassSkill = ns_class_code_to_skill($dbClassCode);
            if ($dbClassSkill !== null) {
                $charData->character_class = $dbClassSkill;
            }

            // Tambahkan field identitas dasar yang dipakai PvP panel
            $charData->character_name  = isset($character['character_name'])  ? (string)$character['character_name']  : '';
            $charData->character_level = isset($character['character_level']) ? (int)$character['character_level']    : 1;

            // Elemen utama diisi dari hasil perhitungan di atas
            $charData->character_element_1 = isset($character['character_element_1']) ? (int)$character['character_element_1'] : 0;
            $charData->character_element_2 = isset($character['character_element_2']) ? (int)$character['character_element_2'] : 0;
            $charData->character_element_3 = isset($character['character_element_3']) ? (int)$character['character_element_3'] : 0;

            $charData->character_senjutsu   = '';
            $charData->character_ss         = 0;
            $charData->character_pvp_points = 0;
            $charData->character_merit      = 0;

            // Debug khusus untuk cek persistensi class saat login
            file_put_contents(
                __DIR__ . '/debug_class.log',
                "SystemLogin.getCharacterData char_id=" . $charId .
                " db_class_code=" . $dbClassCode .
                " db_class_skill=" . var_export($dbClassSkill, true) .
                " resp_class=" . var_export($charData->character_class, true) . "\n",
                FILE_APPEND
            );

            $responseObj->status              = 1;
            $responseObj->character_sets      = $characterSets;
            $responseObj->pet_data            = $petData;
            $responseObj->character_inventory = $characterInventory;
            $responseObj->character_slots     = $characterSlots;
            $responseObj->character_points    = $characterPoints;
            $responseObj->events              = $events;
            $responseObj->recruiters          = array();
            $responseObj->recruit_data        = array();
            $responseObj->has_unread_mails    = 0;
            $responseObj->character_data      = $charData;
            $responseObj->features            = new stdClass();
            $responseObj->clan                = null;
            $responseObj->announcements       = '';

        } catch (Exception $ce) {
            $responseObj->status = 0;
            $responseObj->error  = $ce->getMessage();
        }

        file_put_contents(
            __DIR__ . "/debug_result.log",
            "SERVICE={$service} METHOD={$method}\n" . print_r($responseObj, true) . "\n",
            FILE_APPEND
        );

    } elseif ($service === 'Analytics' && $method === 'libraries') {

        $responseObj->status = 1;
        $responseObj->result = array();

        file_put_contents(
            __DIR__ . "/debug_result.log",
            "SERVICE={$service} METHOD={$method}\n" . print_r($responseObj, true) . "\n",
            FILE_APPEND
        );

    } elseif ($service === 'EudemonGarden') {

        if ($method === 'getData') {

            // Minimal stub for EudemonGarden.getData: provide attempts string for bosses
            // Client expects: { status: 1, data: "a,b,c,..." }
            $responseObj->status = 1;

            // For now, give 10 bosses with 3 attempts each
            $attempts = array_fill(0, 10, 3);
            $responseObj->data = implode(',', $attempts);

        } elseif ($method === 'startHunting') {

            // Payload: [char_id, boss_num, sessionKey]
            $charId   = isset($data[0]) ? (int)$data[0] : 0;
            $bossNum  = isset($data[1]) ? (int)$data[1] : 0;
            $sessKey  = isset($data[2]) ? (string)$data[2] : '';

            // Minimal: accept any request and return a dummy battle code + hash
            $battleCode = substr(sha1($charId . '|' . $bossNum . '|' . $sessKey . '|' . microtime(true)), 0, 10);
            $hash       = hash('sha256', $charId . $battleCode . $bossNum);

            $responseObj->status = 1;
            $responseObj->code   = $battleCode;
            $responseObj->hash   = $hash;

        } elseif ($method === 'finishHunting') {

    // Payload from Battle.as: [char_id, boss_num, battle_code, hash, sessionKey, s]
    $charId = isset($data[0]) ? (int)$data[0] : 0;
    $bossNum = isset($data[1]) ? (int)$data[1] : 0;
    // $battleCode = $data[2], $hash = $data[3], $sessionKey = $data[4] (bisa diabaikan untuk sekarang)

    // TODO kalau mau: validasi sessionKey / hash, update attempts di DB, beri reward, dsb.

    // Ambil level/xp terbaru karakter dari DB (optional tapi lebih rapi),
    // atau pakai level/xp yang sudah ada di Character, tapi aman kalau konsisten.
    // Untuk sekarang, bisa saja:
    // - tidak ubah level/xp (xp 0, level tetap) => level_up=false

    $responseObj->status   = 1;
    $responseObj->xp       = 0;               // tidak ada xp tambahan
    $responseObj->level    = 90;
    $responseObj->level_up = false;

    // Result array: [gold_didapat, token_didapat, pesan]
    $responseObj->result = array(
        0,          // gold
        0,          // token
        'Eudemon Garden Clear'  // message string
    );
}

        file_put_contents(
            __DIR__ . "/debug_result.log",
            "SERVICE={$service} METHOD={$method}\n" . print_r($responseObj, true) . "\n",
            FILE_APPEND
        );

    } elseif ($service === 'TalentService') {

        if ($method === 'getTalentSkills') {

            // Payload: [char_id, sessionKey]
            // Client expects: { status: 1, data: [ { item_id, item_level, talent_type }, ... ] }
            $charId     = isset($data[0]) ? (int)$data[0] : 0;
            $sessionKey = isset($data[1]) ? (string)$data[1] : '';

            try {
                $account = validateSessionKey($sessionKey);
                if (!$account) {
                    throw new Exception('Invalid session');
                }

                $db = getDBConnection();

                $stmt = $db->prepare("SELECT character_skill_talent FROM characters WHERE character_id = ? AND account_id = ? LIMIT 1");
                $stmt->execute(array($charId, $account['account_id']));
                $row = $stmt->fetch(PDO::FETCH_ASSOC);

                $talArr = array();
                if ($row && !empty($row['character_skill_talent'])) {
                    $decoded = json_decode($row['character_skill_talent'], true);
                    if (is_array($decoded) && !empty($decoded) && isset($decoded[0]['kind'])) {
                        $talArr = $decoded;
                    }
                }

                $normalized = array();

                if (!empty($talArr)) {
                    $treeBySlot = array();      // slot => talent_id

                    foreach ($talArr as $entry) {
                        if (!is_array($entry) || !isset($entry['kind'])) {
                            continue;
                        }

                        if ($entry['kind'] === 'tree') {
                            $slot     = isset($entry['slot']) ? (int)$entry['slot'] : 0;
                            $talentId = isset($entry['talent_id']) ? (string)$entry['talent_id'] : '';
                            if ($slot >= 1 && $slot <= 3 && $talentId !== '') {
                                $treeBySlot[$slot] = $talentId;
                            }
                        } elseif ($entry['kind'] === 'skill') {
                            $skillId = isset($entry['skill_id']) ? (string)$entry['skill_id'] : '';
                            $level   = isset($entry['level']) ? (int)$entry['level'] : 0;
                            $slot    = isset($entry['slot']) ? (int)$entry['slot'] : 0;
                            if ($skillId === '' || $level <= 0 || $slot < 1 || $slot > 3) {
                                continue;
                            }

                            // Map each concrete skill entry to its tree via slot.
                            $talentId = isset($treeBySlot[$slot]) ? (string)$treeBySlot[$slot] : '';

                            $normalized[] = array(
                                'item_id'    => (string)$skillId,
                                'item_level' => (int)$level,
                                'talent_type'=> $talentId,
                            );
                        }
                    }
                }

                $responseObj->status = 1;
                $responseObj->data   = $normalized;

                // DEBUG: kirim juga JSON mentah talent ke log untuk analisa struktur tree/skill
                $responseObj->debug_talent_raw = $row && isset($row['character_skill_talent'])
                    ? $row['character_skill_talent']
                    : null;

            } catch (Exception $e) {
                $responseObj->status = 0;
                $responseObj->error  = $e->getMessage();
            }

        } elseif ($method === 'upgradeSkill') {

            // Payload: [char_id, sessionKey, skill_id, isMax, slotHint(optional 1-3)]
            $charId     = isset($data[0]) ? (int)$data[0] : 0;
            $sessionKey = isset($data[1]) ? (string)$data[1] : '';
            $skillId    = isset($data[2]) ? (string)$data[2] : '';
            $slotHint   = isset($data[4]) ? (int)$data[4] : 0;

            try {
                $account = validateSessionKey($sessionKey);
                if (!$account) {
                    throw new Exception('Invalid session');
                }

                if ($charId <= 0 || $skillId === '') {
                    throw new Exception('Invalid parameters');
                }

                $db = getDBConnection();

                // Ambil TP dan talent data
                $stmt = $db->prepare("SELECT character_tp, character_skill_talent FROM characters WHERE character_id = ? AND account_id = ? LIMIT 1");
                $stmt->execute(array($charId, $account['account_id']));
                $row = $stmt->fetch(PDO::FETCH_ASSOC);

                if (!$row) {
                    throw new Exception('Character not found');
                }

                $currentTp = isset($row['character_tp']) ? (int)$row['character_tp'] : 0;

                // Untuk sekarang: setiap level-up menghabiskan 1 TP
                if ($currentTp <= 0) {
                    $responseObj->status = 2;
                    $responseObj->result = 'Not enough TP';
                } else {

                    // Simpan JSON mentah sebelum perubahan untuk keperluan debug
                    $beforeJson = isset($row['character_skill_talent']) ? $row['character_skill_talent'] : null;

                    $talArr = array();
                    if (!empty($row['character_skill_talent'])) {
                        $decoded = json_decode($row['character_skill_talent'], true);
                        if (is_array($decoded) && !empty($decoded) && isset($decoded[0]['kind'])) {
                            $talArr = $decoded;
                        }
                    }

                    // Kumpulkan slot tree yang aktif (1 = Extreme, 2/3 = Secret)
                    $treeSlots = array();
                    foreach ($talArr as $entry) {
                        if (!is_array($entry) || !isset($entry['kind']) || $entry['kind'] !== 'tree') {
                            continue;
                        }
                        $s = isset($entry['slot']) ? (int)$entry['slot'] : 0;
                        if ($s >= 1 && $s <= 3) {
                            $treeSlots[] = $s;
                        }
                    }
                    sort($treeSlots);

                    $updated      = false;
                    $slotForSkill = 1;

                    // Jika client mengirim petunjuk slot (1 = Extreme, 2/3 = Secret), pakai itu sebagai prioritas.
                    if ($slotHint >= 1 && $slotHint <= 3) {
                        $slotForSkill = $slotHint;
                    }

                    // Pertama, coba update entry skill yang sudah ada, diprioritaskan ke slot yang diminta.
                    foreach ($talArr as &$entry) {
                        if (!is_array($entry) || !isset($entry['kind']) || $entry['kind'] !== 'skill' || !isset($entry['skill_id'])) {
                            continue;
                        }
                        if ((string)$entry['skill_id'] === $skillId) {
                            $entrySlot = isset($entry['slot']) ? (int)$entry['slot'] : 0;

                            // Jika ada petunjuk slot dan entry ini bukan untuk slot tersebut, lewati.
                            if ($slotHint >= 1 && $slotHint <= 3 && $entrySlot !== 0 && $entrySlot !== $slotHint) {
                                continue;
                            }

                            $oldLvl = isset($entry['level']) ? (int)$entry['level'] : 0;
                            if ($oldLvl < 10) {
                                $entry['level'] = $oldLvl + 1;
                            }

                            // Pastikan slot untuk skill yang sudah ada selalu valid
                            if ($entrySlot >= 1 && $entrySlot <= 3) {
                                $slotForSkill = $entrySlot;
                            } else {
                                // fallback: pakai tree pertama bila ada
                                $slotForSkill = !empty($treeSlots) ? (int)$treeSlots[0] : 1;
                                $entry['slot'] = $slotForSkill;
                            }

                            $updated = true;
                            break;
                        }
                    }
                    unset($entry);

                    // Jika skill belum ada di list, tambahkan dengan level 1
                    if (!$updated) {
                        // Jika tidak ada petunjuk slot dari client, gunakan perilaku lama.
                        if ($slotHint < 1 || $slotHint > 3) {
                            if (!empty($treeSlots)) {
                                $slotForSkill = (int)$treeSlots[count($treeSlots) - 1];
                            } else {
                                $slotForSkill = 1;
                            }
                        }

                        $talArr[] = array(
                            'kind'     => 'skill',
                            'skill_id' => (string)$skillId,
                            'level'    => 1,
                            'slot'     => $slotForSkill,
                        );
                    }

                    $newTp = $currentTp - 1;
                    if ($newTp < 0) {
                        $newTp = 0;
                    }

                    $newJson = json_encode($talArr);
                    $upd = $db->prepare("UPDATE characters SET character_tp = ?, character_skill_talent = ? WHERE character_id = ? AND account_id = ?");
                    $upd->execute(array($newTp, $newJson, $charId, $account['account_id']));

                    $responseObj->status     = 1;
                    $responseObj->current_tp = $newTp;

                    // DEBUG: log skill yang di-upgrade dan perubahan JSON talent
                    $responseObj->debug_skill_id  = (string)$skillId;
                    $responseObj->debug_before_js = $beforeJson;
                    $responseObj->debug_after_js  = $newJson;
                }

            } catch (Exception $e) {
                $responseObj->status = 0;
                $responseObj->error  = $e->getMessage();
            }

        } elseif ($method === 'buyPackageTP') {

            // Payload: [char_id, sessionKey, package_index(0-3)]
            // Client (TalentBoost.as) expects: { status:1, price:int, add:int, current_tp:int, tokens:int }
            $charId     = isset($data[0]) ? (int)$data[0] : 0;
            $sessionKey = isset($data[1]) ? (string)$data[1] : '';
            $packageIdx = isset($data[2]) ? (int)$data[2] : 0;

            // Package definition must match TalentBoost.as
            // index: 0 => 20 TP for 20 Token
            //        1 => 125 TP for 100 Token
            //        2 => 250 TP for 200 Token
            //        3 => 600 TP for 400 Token
            $tpAddPackages      = array(20, 125, 250, 600);
            $tokenPricePackages = array(20, 100, 200, 400);

            if (!isset($tpAddPackages[$packageIdx]) || !isset($tokenPricePackages[$packageIdx])) {
                $responseObj->status = 2;
                $responseObj->result = 'Invalid package';
            } else {

                $tpAdd  = (int)$tpAddPackages[$packageIdx];
                $price  = (int)$tokenPricePackages[$packageIdx];

                try {
                    $account = validateSessionKey($sessionKey);
                    if (!$account) {
                        throw new Exception('Invalid session');
                    }

                    $db = getDBConnection();

                    // Ambil TP dan token saat ini dari karakter
                    $stmt = $db->prepare("
                        SELECT character_tp, character_token
                        FROM characters
                        WHERE character_id = ? AND account_id = ?
                        LIMIT 1
                    ");
                    $stmt->execute(array($charId, $account['account_id']));
                    $row = $stmt->fetch(PDO::FETCH_ASSOC);

                    $currentTp    = $row && isset($row['character_tp'])    ? (int)$row['character_tp']    : 0;
                    $currentToken = $row && isset($row['character_token']) ? (int)$row['character_token'] : 0;

                    if ($currentToken < $price) {
                        // Tidak cukup token
                        $responseObj->status = 2;
                        $responseObj->result = 'Not enough tokens';
                    } else {

                        $newTp    = $currentTp + $tpAdd;
                        $newToken = $currentToken - $price;

                        // Simpan ke DB
                        $upd = $db->prepare("
                            UPDATE characters
                            SET character_tp = ?, character_token = ?
                            WHERE character_id = ? AND account_id = ?
                        ");
                        $upd->execute(array($newTp, $newToken, $charId, $account['account_id']));

                        // Hitung ulang total token untuk akun ini (dipakai CharacterSelect)
                        $stmtTok = $db->prepare("
                            SELECT SUM(character_token) AS tokens
                            FROM characters
                            WHERE account_id = ?
                        ");
                        $stmtTok->execute(array($account['account_id']));
                        $rowTok = $stmtTok->fetch(PDO::FETCH_ASSOC);
                        $totalTokens = $rowTok && $rowTok['tokens'] !== null ? (int)$rowTok['tokens'] : 0;

                        $responseObj->status     = 1;
                        $responseObj->price      = $price;   // akan dikurangkan dari Character.account_tokens di client
                        $responseObj->add        = $tpAdd;   // jumlah TP yang ditambahkan (untuk pesan)
                        $responseObj->current_tp = $newTp;   // TP terbaru, disalin ke Character.character_tp
                        $responseObj->tokens     = $totalTokens; // total token akun setelah pembelian
                    }

                } catch (Exception $e) {
                    $responseObj->status = 0;
                    $responseObj->error  = $e->getMessage();
                }
            }

        } elseif ($method === 'discoverTalent') {

            // Payload: [char_id, sessionKey, mode("Extreme"|"Secret"), talent_id]
            // Client expects: { status:1, newt:1|2|3, tokens, golds }
            $charId     = isset($data[0]) ? (int)$data[0] : 0;
            $sessionKey = isset($data[1]) ? (string)$data[1] : '';
            $mode       = isset($data[2]) ? (string)$data[2] : 'Extreme';
            $talentId   = isset($data[3]) ? (string)$data[3] : '';

            try {
                $account = validateSessionKey($sessionKey);
                if (!$account) {
                    throw new Exception('Invalid session');
                }

                if ($charId <= 0 || $talentId === '') {
                    throw new Exception('Invalid parameters');
                }

                $db = getDBConnection();

                // Ambil gold, token, dan talent data saat ini
                $stmt = $db->prepare("SELECT character_gold, character_token, character_skill_talent FROM characters WHERE character_id = ? AND account_id = ? LIMIT 1");
                $stmt->execute(array($charId, $account['account_id']));
                $row = $stmt->fetch(PDO::FETCH_ASSOC);

                if (!$row) {
                    throw new Exception('Character not found');
                }

                $gold  = isset($row['character_gold'])  ? (int)$row['character_gold']  : 0;
                $token = isset($row['character_token']) ? (int)$row['character_token'] : 0;

                // Decode talent data saat ini
                $talArr = array();
                if (!empty($row['character_skill_talent'])) {
                    $decoded = json_decode($row['character_skill_talent'], true);
                    if (is_array($decoded) && !empty($decoded) && isset($decoded[0]['kind'])) {
                        $talArr = $decoded;
                    }
                }

                // Tentukan slot talent:
                // 1 = Extreme (bloodline)
                // 2 = Secret slot pertama
                // 3 = Secret slot kedua
                if ($mode === 'Extreme') {
                    $slot = 1;
                } else {
                    // Mode "Secret": cari secret slot yang masih kosong
                    $usedSecretSlots = array();
                    foreach ($talArr as $entry) {
                        if (!is_array($entry) || !isset($entry['kind']) || $entry['kind'] !== 'tree') {
                            continue;
                        }
                        $s = isset($entry['slot']) ? (int)$entry['slot'] : 0;
                        if ($s === 2 || $s === 3) {
                            $usedSecretSlots[$s] = true;
                        }
                    }

                    if (!isset($usedSecretSlots[2])) {
                        // Belum ada secret pertama
                        $slot = 2;
                    } elseif (!isset($usedSecretSlots[3])) {
                        // Secret pertama sudah ada, pakai slot kedua
                        $slot = 3;
                    } else {
                        // Jika dua-duanya sudah terisi, untuk sekarang override secret pertama
                        $slot = 2;
                    }
                }

                // Hapus semua tree/skill yang memakai slot ini
                $filtered = array();
                foreach ($talArr as $entry) {
                    if (!is_array($entry) || !isset($entry['kind'])) {
                        continue;
                    }
                    if (($entry['kind'] === 'tree' || $entry['kind'] === 'skill') && isset($entry['slot']) && (int)$entry['slot'] === $slot) {
                        continue;
                    }
                    $filtered[] = $entry;
                }

                $talArr = $filtered;

                // Tambahkan tree baru untuk slot ini
                $talArr[] = array(
                    'kind'      => 'tree',
                    'slot'      => $slot,
                    'talent_id' => (string)$talentId,
                );

                $newJson = json_encode($talArr);
                $upd = $db->prepare("UPDATE characters SET character_skill_talent = ? WHERE character_id = ? AND account_id = ?");
                $upd->execute(array($newJson, $charId, $account['account_id']));

                // Hitung ulang total token akun untuk UI
                $stmtTok = $db->prepare("SELECT SUM(character_token) AS tokens FROM characters WHERE account_id = ?");
                $stmtTok->execute(array($account['account_id']));
                $rowTok = $stmtTok->fetch(PDO::FETCH_ASSOC);
                $totalTokens = $rowTok && $rowTok['tokens'] !== null ? (int)$rowTok['tokens'] : 0;

                $responseObj->status = 1;
                $responseObj->newt   = $slot;
                $responseObj->tokens = $totalTokens;
                $responseObj->golds  = $gold;

            } catch (Exception $e) {
                $responseObj->status = 0;
                $responseObj->error  = $e->getMessage();
            }
        }

        file_put_contents(
            __DIR__ . "/debug_result.log",
            "SERVICE={$service} METHOD={$method}\n" . print_r($responseObj, true) . "\n",
            FILE_APPEND
        );

    } elseif ($service === 'PvPService') {
    // Stub untuk service PvP yang dipakai client Live PvP
    if ($method === 'checkAccess') {
        // Payload: [char_id, sessionKey]
        $charId     = isset($data[0]) ? (int)$data[0] : 0;
        $sessionKey = isset($data[1]) ? (string)$data[1] : '';
        try {
            // Validasi session; kalau gagal, tolak
            $account = validateSessionKey($sessionKey);
            if (!$account) {
                $responseObj->status = 0;
                $responseObj->error  = 'Invalid session';
            } else {
                // Untuk sekarang: selalu izinkan akses dan kirim field url apa saja
                // Client hanya cek status == 1 dan ada property url,
                // lalu memanggil main.loadPvpPanel().
                $responseObj->status = 1;
                $responseObj->url    = 'local';
            }
        } catch (Exception $e) {
            $responseObj->status = 0;
            $responseObj->error  = $e->getMessage();
        }
        file_put_contents(
            __DIR__ . "/debug_result.log",
            "SERVICE={$service} METHOD={$method}\n" . print_r($responseObj, true) . "\n",
            FILE_APPEND
        );
    } elseif ($method === 'getCharacterStats') {

        // Payload: [char_id, sessionKey]
        $charId     = isset($data[0]) ? (int)$data[0] : 0;
        $sessionKey = isset($data[1]) ? (string)$data[1] : '';

        try {
            $account = validateSessionKey($sessionKey);
            if (!$account || $charId <= 0) {
                $responseObj->status = 0;
                $responseObj->error  = 'Invalid session or character';
            } else {

                $db = getDBConnection();

                // Ambil atribut dan beberapa field PvP dasar dari karakter.
                // Sumber data disamakan dengan SystemLogin.getCharacterData:
                // gunakan character_wind/fire/lightning/water/earth dan mapping ke attrrib_*.
                $stmt = $db->prepare("SELECT 
                        character_wind,
                        character_fire,
                        character_lightning,
                        character_water,
                        character_earth,
                        character_class,
                        character_senjutsu,
                        character_ss,
                        character_pvp_point,
                        character_merit
                    FROM characters
                    WHERE character_id = ? AND account_id = ?
                    LIMIT 1");
                $stmt->execute(array($charId, $account['account_id']));
                $row = $stmt->fetch(PDO::FETCH_ASSOC);

                if (!$row) {
                    $responseObj->status = 0;
                    $responseObj->error  = 'Character not found';
                } else {

                    $slots = new stdClass();
                    $slots->weapons    = 1;
                    $slots->back_items = 1;
                    $slots->accessories= 1;
                    $slots->hairstyles = 1;
                    $slots->clothing   = 1;

                    $points = new stdClass();
                    $points->atrrib_wind      = isset($row['character_wind'])      ? (int)$row['character_wind']      : 0;
                    $points->atrrib_fire      = isset($row['character_fire'])      ? (int)$row['character_fire']      : 0;
                    $points->atrrib_lightning = isset($row['character_lightning']) ? (int)$row['character_lightning'] : 0;
                    $points->atrrib_water     = isset($row['character_water'])     ? (int)$row['character_water']     : 0;
                    $points->atrrib_earth     = isset($row['character_earth'])     ? (int)$row['character_earth']     : 0;

                    // Client akan hitung ulang free points berdasarkan level dan total di atas.
                    $points->atrrib_free      = 0;

                    $events = new stdClass();
                    $events->welcome_bonus = 0;

                    $characterData = new stdClass();
            $characterData->character_class = null;
            $codeClass = isset($row['character_class']) ? (int)$row['character_class'] : 0;
            $skillClass = ns_class_code_to_skill($codeClass);
            if ($skillClass !== null) {
                $characterData->character_class = $skillClass;
            }

            $characterData->character_senjutsu   = isset($row['character_senjutsu'])   ? (string)$row['character_senjutsu']   : '';
            $characterData->character_ss         = isset($row['character_ss'])         ? (int)$row['character_ss']            : 0;
            $characterData->character_pvp_points = isset($row['character_pvp_point'])  ? (int)$row['character_pvp_point']     : 0;
            $characterData->character_merit      = isset($row['character_merit'])      ? (int)$row['character_merit']         : 0;

                    $responseObj->status           = 1;
                    $responseObj->character_slots  = $slots;
                    $responseObj->character_points = $points;
                    $responseObj->events           = $events;
                    $responseObj->recruiters       = array();
                    $responseObj->recruit_data     = array();
                    $responseObj->has_unread_mails = 0;
                    $responseObj->character_data   = $characterData;
                    $responseObj->features         = new stdClass();
                    $responseObj->clan             = null;
                    $responseObj->announcements    = null;
                }
            }
        } catch (Exception $e) {
            $responseObj->status = 0;
            $responseObj->error  = $e->getMessage();
        }

        file_put_contents(
            __DIR__ . "/debug_result.log",
            "SERVICE={$service} METHOD={$method}\n" . print_r($responseObj, true) . "\n",
            FILE_APPEND
        );
    } elseif ($method === 'getLeaderboard') {
        // Minimal PvP leaderboard kosong supaya panel tidak error
        $responseObj->status = 1;
        $responseObj->trophy = 0;      // trophy player sendiri
        $responseObj->data   = array(); // tidak ada data rank
        file_put_contents(
            __DIR__ . "/debug_result.log",
            "SERVICE={$service} METHOD={$method}\n" . print_r($responseObj, true) . "\n",
            FILE_APPEND
        );
    } else {
        // Method PvPService lain belum diimplementasikan
        $responseObj->status = 0;
        $responseObj->error  = 'Unknown PvPService method';
        file_put_contents(
            __DIR__ . "/debug_result.log",
            "SERVICE={$service} METHOD={$method}\n" . print_r($responseObj, true) . "\n",
            FILE_APPEND
        );
    }
} elseif ($service === 'EventsService' && $method === 'get') {

        // Minimal EventsService.get: return empty seasonal events list
        $responseObj->status = 1;
        $events = new stdClass();
        $events->seasonal = array();
        $responseObj->events = $events;

        file_put_contents(
            __DIR__ . "/debug_result.log",
            "SERVICE={$service} METHOD={$method}\n" . print_r($responseObj, true) . "\n",
            FILE_APPEND
        );

    } elseif ($service === 'CharacterService') {

        if ($method === 'getInfo') {

            // Payload variants:
            // - Combat.CharacterModel: [viewerCharId, sessionKey, targetCharId, battleMode]
            // - UI_Friend_Profile / Social / ClanMemberRequest: [viewerCharId, sessionKey, targetCharId]
            $viewerCharId = isset($data[0]) ? (int)$data[0] : 0;
            $sessionKey   = isset($data[1]) ? (string)$data[1] : '';
            $targetCharId = isset($data[2]) ? (int)$data[2] : 0;

            try {
                $account = validateSessionKey($sessionKey);
                if (!$account) {
                    throw new Exception('Invalid session');
                }

                $db = getDBConnection();

                // Ambil data karakter target berdasarkan character_id saja
                $stmt = $db->prepare("SELECT * FROM characters WHERE character_id = ? LIMIT 1");
                $stmt->execute(array($targetCharId));
                $character = $stmt->fetch(PDO::FETCH_ASSOC);

                if (!$character) {
                    // Untuk pencarian friend / clan, client expect status>1 + result sebagai pesan
                    $responseObj->status = 2;
                    $responseObj->result = 'Character not found';

                } else {

                    // Decode JSON dasar yang diperlukan
                    $invArr = array();
                    if (!empty($character['character_inventory'])) {
                        $decodedInv = json_decode($character['character_inventory'], true);
                        if (is_array($decodedInv)) {
                            $invArr = $decodedInv;
                        }
                    }

                    $bodyParts = array();
                    if (!empty($character['character_body_parts'])) {
                        $decodedBody = json_decode($character['character_body_parts'], true);
                        if (is_array($decodedBody)) {
                            $bodyParts = $decodedBody;
                        }
                    }

                    // --- derive elements from attribute stats ---
                    $elemStats = array(
                        1 => isset($character['character_wind'])      ? (int)$character['character_wind']      : 0,
                        2 => isset($character['character_fire'])      ? (int)$character['character_fire']      : 0,
                        3 => isset($character['character_lightning']) ? (int)$character['character_lightning'] : 0,
                        4 => isset($character['character_earth'])     ? (int)$character['character_earth']     : 0,
                        5 => isset($character['character_water'])     ? (int)$character['character_water']     : 0,
                    );
                    $elements = array();
                    foreach ($elemStats as $idx => $val) {
                        if ($val > 0) {
                            $elements[] = $idx;
                        }
                    }

                    $elem1 = isset($elements[0]) ? $elements[0] : 0;
                    $elem2 = isset($elements[1]) ? $elements[1] : 0;
                    $elem3 = isset($elements[2]) ? $elements[2] : 0;

                    // --- character_sets ---
                    $characterSets = new stdClass();

                    // Gender dipakai untuk default asset (0 = male, 1 = female)
                    $gender = isset($character['character_gender']) ? (int)$character['character_gender'] : 0;

                    // Weapon ID: normalisasi dari "wpn1" -> "wpn_01" dan set default kalau kosong
                    $weaponId = '';
                    if (!empty($character['character_equipped_weapon'])) {
                        $weaponId = (string)$character['character_equipped_weapon'];
                        if (preg_match('/^wpn(\d+)$/', $weaponId, $mW)) {
                            $weaponId = 'wpn_' . str_pad($mW[1], 2, '0', STR_PAD_LEFT);
                        }
                    }
                    if ($weaponId === '') {
                        $weaponId = 'wpn_01';
                    }
                    $characterSets->weapon = $weaponId;

                    // Back item: normalisasi dari "back1" -> "back_01" dan default ke back_01 kalau kosong
                    $backId = '';
                    if (!empty($character['character_equipped_back_item'])) {
                        $backId = (string)$character['character_equipped_back_item'];
                        if (preg_match('/^back(\d+)$/', $backId, $mB)) {
                            $backId = 'back_' . str_pad($mB[1], 2, '0', STR_PAD_LEFT);
                        }
                    }
                    if ($backId === '') {
                        $backId = 'back_01';
                    }
                    $characterSets->back_item = $backId;

                    // Accessory: ambil dari kolom equipped kalau ada, kalau tidak coba dari JSON body_parts.accessory
                    $accessoryId = '';
                    if (!empty($character['character_equipped_accessory'])) {
                        $accessoryId = (string)$character['character_equipped_accessory'];
                    } elseif (!empty($bodyParts) && !empty($bodyParts['accessory'])) {
                        $accessoryId = (string)$bodyParts['accessory'];
                    }
                    $characterSets->accessory = $accessoryId;

                    // Set / clothing: gunakan character_body_set kalau ada, kalau kosong pakai set dasar sesuai gender
                    $setId = '';
                    if (!empty($character['character_body_set'])) {
                        $setId = (string)$character['character_body_set'];
                    }

                    if ($setId !== '' && preg_match('/^set(\d+)$/', $setId, $mSet)) {
                        $num   = (int)$mSet[1];
                        $setId = 'set_' . str_pad($num, 2, '0', STR_PAD_LEFT) . '_' . $gender;
                    } elseif ($setId !== '' && preg_match('/^set_(\d+)_([01])$/', $setId, $mSet2)) {
                        // Data sudah dalam format baru tetapi suffix gender bisa saja tidak sesuai,
                        // paksa suffix agar selalu sama dengan character_gender
                        $num   = (int)$mSet2[1];
                        $setId = 'set_' . str_pad($num, 2, '0', STR_PAD_LEFT) . '_' . $gender;
                    }

                    if ($setId === '') {
                        $setId = 'set_01_' . $gender;
                    }
                    $characterSets->clothing = $setId;

                    // Hairstyle: perbaiki data lama "2_0" -> "hair_02_0".
                    $hairId = '';
                    if (!empty($character['character_hair'])) {
                        $hairId = (string)$character['character_hair'];
                        if (preg_match('/^(\d+)_([01])$/', $hairId, $mHair)) {
                            $hairNum    = (int)$mHair[1];
                            $hairGender = $mHair[2];
                            $hairId = 'hair_' . str_pad($hairNum, 2, '0', STR_PAD_LEFT) . '_' . $hairGender;
                        }
                    } elseif (!empty($character['character_face']) && preg_match('/^(\d+)_([01])$/', (string)$character['character_face'], $mHairFromFace)) {
                        // Beberapa karakter lama menyimpan index rambut di kolom face
                        $hairNum    = (int)$mHairFromFace[1];
                        $hairGender = $mHairFromFace[2];
                        $hairId = 'hair_' . str_pad($hairNum, 2, '0', STR_PAD_LEFT) . '_' . $hairGender;
                    } else {
                        $hairId = 'hair_01_' . $gender;
                    }
                    $characterSets->hairstyle = $hairId;

                    // Skills yang sedang dipakai:
                    // 1) gunakan kolom character_equipped_skills bila ada
                    // 2) jika kosong, coba ambil dari inventory.skillsets[0].skills
                    $equippedSkills = '';
                    if (!empty($character['character_equipped_skills'])) {
                        $equippedSkills = (string)$character['character_equipped_skills'];
                    } elseif (
                        isset($invArr['skillsets']) &&
                        is_array($invArr['skillsets']) &&
                        !empty($invArr['skillsets'])
                    ) {
                        $firstSet = $invArr['skillsets'][0];
                        if (is_array($firstSet) && isset($firstSet['skills'])) {
                            $equippedSkills = (string)$firstSet['skills'];
                        } elseif (is_object($firstSet) && isset($firstSet->skills)) {
                            $equippedSkills = (string)$firstSet->skills;
                        }
                    }
                    $characterSets->skills = $equippedSkills;

                    // Hair color sebagai string "a|b" (contoh: "123456|654321") atau default "0|0"
                    if (isset($character['character_hair_color'])) {
                        $hairColor = $character['character_hair_color'];

                        // Jika tersimpan sebagai JSON string "[a,b]", decode dulu
                        if (is_string($hairColor) && strlen($hairColor) > 0 && $hairColor[0] === '[') {
                            $decoded = json_decode($hairColor, true);
                            if (is_array($decoded)) {
                                $hairColor = $decoded;
                            }
                        }

                        if (is_array($hairColor)) {
                            $characterSets->hair_color = implode('|', $hairColor);
                        } else {
                            $characterSets->hair_color = (string)$hairColor;
                        }
                    } else {
                        $characterSets->hair_color = '0|0';
                    }

                    // Skin color: gunakan nilai dari DB (character_skin_color) jika ada.
                    // Format yang dipakai client: "a|b" atau "null|null".
                    if (isset($character['character_skin_color'])) {
                        $skinColor = (string)$character['character_skin_color'];

                        // Data lama 0 atau "0|0" dianggap tidak ada override warna
                        if ($skinColor === '' || $skinColor === '0' || $skinColor === '0|0') {
                            $skinColor = 'null|null';
                        }

                        $characterSets->skin_color = $skinColor;
                    } else {
                        $characterSets->skin_color = 'null|null';
                    }

                    // Face: normalisasi data lama seperti "17_0" menjadi face dasar "face_01_0"
                    $faceId = isset($character['character_face']) ? (string)$character['character_face'] : '';
                    if ($faceId === '' || preg_match('/^(\d+)_([01])$/', $faceId)) {
                        $faceId = 'face_01_' . $gender;
                    }
                    $characterSets->face = $faceId;

                    $characterSets->senjutsu_skills = '';
                    $characterSets->anims = new stdClass();

                    // --- character_inventory ---
                    $characterInventory = new stdClass();

                    $characterInventory->char_weapons         = !empty($invArr['char_weapons'])         ? $invArr['char_weapons']         : ($weaponId !== '' ? $weaponId . ':1' : '');
                    $characterInventory->char_back_items      = !empty($invArr['char_back_items'])      ? $invArr['char_back_items']      : ($backId   !== '' ? $backId   . ':1' : '');
                    $characterInventory->char_accessories     = !empty($invArr['char_accessories'])     ? $invArr['char_accessories']     : '';
                    $characterInventory->char_sets            = !empty($invArr['char_sets'])            ? $invArr['char_sets']            : ($setId   !== '' ? $setId   . ':1' : '');
                    $characterInventory->char_hairs           = !empty($invArr['char_hairs'])           ? $invArr['char_hairs']           : ($hairId  !== '' ? $hairId  . ':1' : '');
                    $characterInventory->char_skills          = !empty($invArr['char_skills'])          ? $invArr['char_skills']          : '';
                    $characterInventory->char_talent_skills   = !empty($invArr['char_talent_skills'])   ? $invArr['char_talent_skills']   : '';
                    $characterInventory->char_senjutsu_skills = !empty($invArr['char_senjutsu_skills']) ? $invArr['char_senjutsu_skills'] : '';
                    $characterInventory->char_materials       = !empty($invArr['char_materials'])       ? $invArr['char_materials']       : '';
                    $characterInventory->char_essentials      = !empty($invArr['char_essentials'])      ? $invArr['char_essentials']      : '';
                    $characterInventory->char_items           = !empty($invArr['char_items'])           ? $invArr['char_items']           : '';
                    $characterInventory->char_animations      = !empty($invArr['char_animations'])      ? $invArr['char_animations']      : '';

                    // Sinkronisasi talent battle: bangun char_talent_skills dari JSON character_skill_talent
                    $talentSkillStr = '';
                    if (!empty($character['character_skill_talent'])) {
                        $talDecoded = json_decode($character['character_skill_talent'], true);
                        if (is_array($talDecoded)) {
                            $skillLevels = array(); // skill_id => level
                            foreach ($talDecoded as $entry) {
                                if (!is_array($entry) || !isset($entry['kind']) || $entry['kind'] !== 'skill') {
                                    continue;
                                }
                                $sid = isset($entry['skill_id']) ? (string)$entry['skill_id'] : '';
                                $lvl = isset($entry['level']) ? (int)$entry['level'] : 0;
                                if ($sid === '' || $lvl <= 0) {
                                    continue;
                                }
                                // Jika duplikat muncul, ambil level terakhir
                                $skillLevels[$sid] = $lvl;
                            }
                            if (!empty($skillLevels)) {
                                $pieces = array();
                                foreach ($skillLevels as $sid => $lvl) {
                                    $pieces[] = $sid . ':' . $lvl;
                                }
                                $talentSkillStr = implode(',', $pieces);
                            }
                        }
                    }
                    if ($talentSkillStr !== '') {
                        $characterInventory->char_talent_skills = $talentSkillStr;
                    }

                    // --- character_slots ---
                    $characterSlots = new stdClass();
                    $characterSlots->weapons    = 1;
                    $characterSlots->back_items = 1;
                    $characterSlots->accessories= 1;
                    $characterSlots->hairstyles = 1;
                    $characterSlots->clothing   = 1;

                    // --- character_points --- (atribut elemen diambil dari kolom karakter)
                    $characterPoints = new stdClass();
                    $characterPoints->atrrib_wind      = isset($character['character_wind'])      ? (int)$character['character_wind']      : 0;
                    $characterPoints->atrrib_fire      = isset($character['character_fire'])      ? (int)$character['character_fire']      : 0;
                    $characterPoints->atrrib_lightning = isset($character['character_lightning']) ? (int)$character['character_lightning'] : 0;
                    $characterPoints->atrrib_water     = isset($character['character_water'])     ? (int)$character['character_water']     : 0;
                    $characterPoints->atrrib_earth     = isset($character['character_earth'])     ? (int)$character['character_earth']     : 0;
                    $characterPoints->atrrib_free      = 0;

                    // --- events --- (minimal)
                    $events = new stdClass();
                    $events->welcome_bonus = 0;

                    // --- pet_data --- (equip pet ke battle bila ada)
                    $petData = new stdClass();
                    if (!empty($character['character_pet'])) {
                        $equippedPetSwf = (string)$character['character_pet'];
                        $equippedPetIdx = isset($character['character_pet_id']) ? (int)$character['character_pet_id'] : 0;

                        $petData->pet_id   = $equippedPetIdx;
                        $petData->pet_swf  = $equippedPetSwf;
                        $petData->pet_name = $equippedPetSwf;

                        // Coba ambil detail dari inventory.pet_data[pet_swf]
                        $metaAll = array();
                        if (isset($invArr['pet_data']) && is_array($invArr['pet_data'])) {
                            $metaAll = $invArr['pet_data'];
                        }

                        $meta = array();
                        if (isset($metaAll[$equippedPetSwf]) && is_array($metaAll[$equippedPetSwf])) {
                            $meta = $metaAll[$equippedPetSwf];
                        }

                        $petLevel = isset($meta['level']) ? (int)$meta['level'] : 1;
                        $petXp    = isset($meta['xp'])    ? (int)$meta['xp']    : 0;
                        $petMp    = isset($meta['mp'])    ? (int)$meta['mp']    : 100;
                        $skills   = isset($meta['skills']) ? (string)$meta['skills'] : '0,0,0,0,0,0';

                        // Normalisasi string skills jadi 6 slot angka
                        $skillsArr = explode(',', $skills);
                        $norm      = array();
                        for ($i = 0; $i < 6; $i++) {
                            $val = isset($skillsArr[$i]) ? trim($skillsArr[$i]) : '0';
                            if ($val === '') {
                                $val = '0';
                            }
                            $norm[] = (string)((int)$val);
                        }

                        $petData->pet_level  = $petLevel;
                        $petData->pet_xp     = $petXp;
                        $petData->pet_mp     = $petMp;
                        $petData->pet_skills = implode(',', $norm);

                        if (isset($meta['name']) && $meta['name'] !== '') {
                            $petData->pet_name = (string)$meta['name'];
                        }
                    }

                    // --- character_data ---
                    $charData = new stdClass();
                    $charData->character_id    = isset($character['character_id'])    ? (int)$character['character_id']    : $targetCharId;
                    $charData->character_name  = isset($character['character_name'])  ? (string)$character['character_name']  : '';
                    $charData->character_level = isset($character['character_level']) ? (int)$character['character_level'] : 1;
                    $charData->character_rank  = isset($character['character_rank'])  ? (int)$character['character_rank']  : 0;
                    $charData->character_xp    = isset($character['character_xp'])    ? (int)$character['character_xp']    : 0;

                    $charData->character_element_1 = $elem1;
                    $charData->character_element_2 = $elem2;
                    $charData->character_element_3 = $elem3;

                    // Talent tree dari JSON character_skill_talent (dipakai logo dan panel profil)
                    $talent1 = null;
                    $talent2 = null;
                    $talent3 = null;
                    if (!empty($character['character_skill_talent'])) {
                        $talRaw = json_decode($character['character_skill_talent'], true);
                        if (is_array($talRaw)) {
                            foreach ($talRaw as $entry) {
                                if (!is_array($entry)) {
                                    continue;
                                }
                                if (!isset($entry['kind']) || $entry['kind'] !== 'tree') {
                                    continue;
                                }
                                $slot     = isset($entry['slot']) ? (int)$entry['slot'] : 0;
                                $talentId = isset($entry['talent_id']) ? (string)$entry['talent_id'] : '';
                                if ($talentId === '') {
                                    continue;
                                }
                                if ($slot === 1) {
                                    $talent1 = $talentId;
                                } elseif ($slot === 2) {
                                    $talent2 = $talentId;
                                } elseif ($slot === 3) {
                                    $talent3 = $talentId;
                                }
                            }
                        }
                    }

                    $charData->character_talent_1 = $talent1;
                    $charData->character_talent_2 = $talent2;
                    $charData->character_talent_3 = $talent3;

                    $classVal = null;
                    $codeClass = isset($character['character_class']) ? (int)$character['character_class'] : 0;
                    $classVal = ns_class_code_to_skill($codeClass);
                    $charData->character_class      = $classVal;
                    $charData->character_senjutsu   = '';
                    $charData->character_ss         = 0;
                    $charData->character_pvp_points = 0;
                    $charData->character_merit      = 0;

                    $responseObj->status              = 1;
                    $responseObj->character_sets      = $characterSets;
                    $responseObj->pet_data            = $petData;
                    $responseObj->character_inventory = $characterInventory;
                    $responseObj->character_slots     = $characterSlots;
                    $responseObj->character_points    = $characterPoints;
                    $responseObj->events              = $events;
                    $responseObj->recruiters          = array();
                    $responseObj->recruit_data        = array();
                    $responseObj->has_unread_mails    = 0;
                    $responseObj->character_data      = $charData;
                    $responseObj->features            = new stdClass();
                    $responseObj->clan                = null;
                    $responseObj->announcements       = '';

                    // Friend / social UI memakai field ini untuk emblem premium vs normal
                    $responseObj->account_type = 1;

                    // Untuk keperluan battle, CharacterManagerBase.getSessionKey()
                    $responseObj->sessionkey = $sessionKey;
                }

            } catch (Exception $e) {
                $responseObj->status = 0;
                $responseObj->error  = $e->getMessage();
            }

            file_put_contents(
                __DIR__ . "/debug_result.log",
                "SERVICE={$service} METHOD={$method}\n" . print_r($responseObj, true) . "\n",
                FILE_APPEND
            );

        } elseif ($method === 'changeSpecialClass') {

            // Payload dari SpecialClassChange.confirmedPayToken:
            // [0] = char_id, [1] = sessionKey, [2] = newClassSkill (mis. "skill_4002")
            $charId        = isset($data[0]) ? (int)$data[0] : 0;
            $sessionKey    = isset($data[1]) ? (string)$data[1] : '';
            $newClassSkill = isset($data[2]) ? (string)$data[2] : '';

            try {
                $account = validateSessionKey($sessionKey);
                if (!$account) {
                    throw new Exception('Invalid session');
                }

                if ($charId <= 0 || $newClassSkill === '') {
                    throw new Exception('Invalid parameters');
                }

                $db = getDBConnection();

                // Ambil data karakter + token
                $stmt = $db->prepare("\n                    SELECT character_id, account_id, character_level, character_rank,\n                           character_class, character_token\n                    FROM characters\n                    WHERE character_id = ? AND account_id = ?\n                    LIMIT 1\n                ");
                $stmt->execute(array($charId, $account['account_id']));
                $char = $stmt->fetch(PDO::FETCH_ASSOC);

                if (!$char) {
                    throw new Exception('Character not found');
                }

                // Harga: emblem (account_type=1) 2000 token, free 3000
                $accountType = isset($account['account_type']) ? (int)$account['account_type'] : 0;
                $price       = ($accountType === 1) ? 2000 : 3000;

                $tokens        = isset($char['character_token']) ? (int)$char['character_token'] : 0;
                $oldClassCode  = isset($char['character_class']) ? (int)$char['character_class'] : 0;
                $oldClassSkill = ns_class_code_to_skill($oldClassCode);
                $oldTokens     = $tokens;

                if ($tokens < $price) {
                    // status > 1  di client tampil lewat showMessage(param1.result)
                    $responseObj->status = 2;
                    $responseObj->result = 'Token is not enough!';
                } else {
                    // Konversi skill ID ("skill_400x") dari client ke kode numerik 1..5 untuk disimpan di DB
                    $newClassCode = ns_skill_to_class_code($newClassSkill);

                    // Update class + kurangi token
                    $stmtUp = $db->prepare("\n                        UPDATE characters\n                        SET character_class = ?,\n                            character_token = character_token - ?\n                        WHERE character_id = ? AND account_id = ?\n                    ");
                    $stmtUp->execute(array($newClassCode, $price, $charId, $account['account_id']));

                    // Baca ulang untuk memastikan nilai benar-benar tersimpan di DB
                    $stmtCheck = $db->prepare("\n                        SELECT character_class, character_token\n                        FROM characters\n                        WHERE character_id = ? AND account_id = ?\n                        LIMIT 1\n                    ");
                    $stmtCheck->execute(array($charId, $account['account_id']));
                    $after = $stmtCheck->fetch(PDO::FETCH_ASSOC);

                    $newClassCodeDb  = isset($after['character_class']) ? (int)$after['character_class'] : 0;
                    $newClassSkillDb = ns_class_code_to_skill($newClassCodeDb);

                    // Log perubahan untuk debug persistensi (file terpisah supaya tidak ditimpa login)
                    file_put_contents(
                        __DIR__ . '/debug_class.log',
                        "changeSpecialClass char_id={$charId}\n" .
                        "  old_class_code={$oldClassCode} old_class_skill=" . var_export($oldClassSkill, true) . "\n" .
                        "  new_class_code={$newClassCodeDb} new_class_skill=" . var_export($newClassSkillDb, true) . "\n" .
                        "  old_tokens={$oldTokens} new_tokens=" . (isset($after['character_token']) ? (int)$after['character_token'] : -1) . "\n",
                        FILE_APPEND
                    );

                    $responseObj->status = 1;
                    $responseObj->result = 'Class changed successfully.';
                }

            } catch (Exception $e) {
                $responseObj->status = 0;
                $responseObj->error  = $e->getMessage();
            }

            file_put_contents(
                __DIR__ . "/debug_result.log",
                "SERVICE={$service} METHOD={$method}\n" . print_r($responseObj, true) . "\n",
                FILE_APPEND
            );

        } elseif ($method === 'characterRegister') {

            // Payload format (from client):
            // [0] = account_id, [1] = sha256(session_key), [2] = name,
            // [3] = gender, [4] = element index, [5] = hairColor "a|b", [6] = hair index
            $payload = (isset($data[0]) && is_array($data[0])) ? $data[0] : array();

            $cid         = isset($payload[0]) ? (int)$payload[0] : 0;
            $sessionHash = isset($payload[1]) ? (string)$payload[1] : '';
            $name        = isset($payload[2]) ? (string)$payload[2] : '';
            $gender      = isset($payload[3]) ? (int)$payload[3] : 0;
            $elementIdx  = isset($payload[4]) ? (int)$payload[4] : 0; // belum dipakai
            $hairColorStr= isset($payload[5]) ? (string)$payload[5] : '0|0';
            $hairIndex   = isset($payload[6]) ? (int)$payload[6] : 1;

            $db = getDBConnection();

            // Coba temukan account berdasarkan SHA2(session_key, 256) = sessionHash
            $stmt = $db->prepare("SELECT session_key FROM accounts WHERE SHA2(session_key, 256) = ? LIMIT 1");
            $stmt->execute(array($sessionHash));
            $row = $stmt->fetch();

            if ($row && !empty($row['session_key'])) {

                $sessionKey = $row['session_key'];

                // Parse hair color string "a|b" menjadi array [a, b]
                $parts = explode('|', $hairColorStr);
                $hairColor = array();
                foreach ($parts as $p) {
                    $p = trim($p);
                    if ($p === '') $p = 0;
                    $hairColor[] = (int)$p;
                }
                if (count($hairColor) === 1) {
                    $hairColor[] = 0;
                }

                // Normalisasi index rambut agar minimal 1
                $hairNum = $hairIndex > 0 ? $hairIndex : 1;

                // Sementara, tidak ada pemilihan skin color dan face index dari client,
                // jadi gunakan nilai default 0 untuk skinColor dan 1 untuk face index.
                $skinColorIndex = 0;
                $faceIndex      = 1;

                $charDao = new CharacterDAO($db);

                try {
                    // CharacterDAO.createCharacter(session_key, name, gender, hair_color, skin_color, hairIndex, faceIndex)
                    // hair & face akan disimpan sebagai "<index>_<gender>" (contoh: "17_0").
                    $created = $charDao->createCharacter($sessionKey, $name, $gender, $hairColor, $skinColorIndex, $hairNum, $faceIndex);

                    // Client biasanya hanya butuh status=1; character list di-refresh lewat getAllCharacters
                    $responseObj->status = 1;
                    $responseObj->result = 1;

                } catch (Exception $ce) {
                    $responseObj->status = 0;
                    $responseObj->error  = $ce->getMessage();
                }

            } else {
                // Tidak bisa menemukan session dari hash -> anggap gagal, tapi jangan crash AMF
                $responseObj->status = 0;
                $responseObj->error  = 'Invalid session (hash mismatch)';
            }

            file_put_contents(
                __DIR__ . "/debug_result.log",
                "SERVICE={$service} METHOD={$method}\n" . print_r($responseObj, true) . "\n",
                FILE_APPEND
            );

        } elseif ($method === 'setPoints') {

            // Payload: [char_id, sessionKey, wind, fire, lightning, water, earth, free]
            $charId     = isset($data[0]) ? (int)$data[0] : 0;
            $sessionKey = isset($data[1]) ? (string)$data[1] : '';

            $wind      = isset($data[2]) ? (int)$data[2] : 0;
            $fire      = isset($data[3]) ? (int)$data[3] : 0;
            $lightning = isset($data[4]) ? (int)$data[4] : 0;
            $water     = isset($data[5]) ? (int)$data[5] : 0;
            $earth     = isset($data[6]) ? (int)$data[6] : 0;
            $free      = isset($data[7]) ? (int)$data[7] : 0; // tidak disimpan, hanya hitungan client

            try {
                $account = validateSessionKey($sessionKey);
                if (!$account) {
                    throw new Exception('Invalid session');
                }

                $db = getDBConnection();

                $stmt = $db->prepare("
                    UPDATE characters
                    SET character_wind = ?,
                        character_fire = ?,
                        character_lightning = ?,
                        character_water = ?,
                        character_earth = ?
                    WHERE character_id = ? AND account_id = ?
                ");
                $stmt->execute(array(
                    $wind,
                    $fire,
                    $lightning,
                    $water,
                    $earth,
                    $charId,
                    $account['account_id'],
                ));

                $responseObj->status = 1;

            } catch (Exception $e) {
                $responseObj->status = 0;
                $responseObj->error  = $e->getMessage();
            }

            file_put_contents(
                __DIR__ . "/debug_result.log",
                "SERVICE={$service} METHOD={$method}\n" . print_r($responseObj, true) . "\n",
                FILE_APPEND
            );

        } elseif ($method === 'equipSet') {

            // Payload dari UI_Gear.closePanel:
            // [0] = char_id, [1] = sessionKey,
            // [2] = weaponId (mis. "wpn_01"),
            // [3] = backId   (mis. "back_01"),
            // [4] = setId    (mis. "set_01_1"),
            // [5] = accessoryId (boleh kosong),
            // [6] = hairId   (mis. "hair_14_1"),
            // [7] = hairColorStr ("a|b" atau "null|null"),
            // [8] = skinColorStr ("a|b" atau "null|null").

            $charId       = isset($data[0]) ? (int)$data[0] : 0;
            $sessionKey   = isset($data[1]) ? (string)$data[1] : '';
            $weaponId     = isset($data[2]) ? (string)$data[2] : '';
            $backId       = isset($data[3]) ? (string)$data[3] : '';
            $setId        = isset($data[4]) ? (string)$data[4] : '';
            $accessoryId  = isset($data[5]) ? (string)$data[5] : '';
            $hairId       = isset($data[6]) ? (string)$data[6] : '';
            $hairColorStr = isset($data[7]) ? (string)$data[7] : '';
            $skinColorStr = isset($data[8]) ? (string)$data[8] : '';

            try {
                $account = validateSessionKey($sessionKey);
                if (!$account) {
                    throw new Exception('Invalid session');
                }

                $db = getDBConnection();

                // Update gear utama (weapon, back item, set, hair & colors)
                $stmt = $db->prepare("
                    UPDATE characters
                    SET character_equipped_weapon     = ?,
                        character_equipped_back_item = ?,
                        character_body_set           = ?,
                        character_hair               = ?,
                        character_hair_color         = ?,
                        character_skin_color         = ?
                    WHERE character_id = ? AND account_id = ?
                ");
                $stmt->execute(array(
                    $weaponId,
                    $backId,
                    $setId,
                    $hairId,
                    $hairColorStr,
                    $skinColorStr,
                    $charId,
                    $account['account_id'],
                ));

                // Simpan accessory yang dipakai ke dalam JSON character_body_parts.accessory
                // supaya persistent tanpa perlu kolom baru di tabel characters.
                $bodyParts = array();
                $stmtBody  = $db->prepare("
                    SELECT character_body_parts
                    FROM characters
                    WHERE character_id = ? AND account_id = ?
                ");
                $stmtBody->execute(array($charId, $account['account_id']));
                $rowBody = $stmtBody->fetch(PDO::FETCH_ASSOC);
                if ($rowBody && !empty($rowBody['character_body_parts'])) {
                    $decoded = json_decode($rowBody['character_body_parts'], true);
                    if (is_array($decoded)) {
                        $bodyParts = $decoded;
                    }
                }

                // Update / set field accessory di dalam JSON
                $bodyParts['accessory'] = $accessoryId;
                $bodyPartsJson = json_encode($bodyParts);

                $stmtUpdateBody = $db->prepare("
                    UPDATE characters
                    SET character_body_parts = ?
                    WHERE character_id = ? AND account_id = ?
                ");
                $stmtUpdateBody->execute(array($bodyPartsJson, $charId, $account['account_id']));

                $responseObj->status = 1;

            } catch (Exception $e) {
                $responseObj->status = 0;
                $responseObj->error  = $e->getMessage();
            }

            file_put_contents(
                __DIR__ . "/debug_result.log",
                "SERVICE={$service} METHOD={$method}\n" . print_r($responseObj, true) . "\n",
                FILE_APPEND
            );

        } elseif ($method === 'equipSkillSet') {

            // Payload dari UI_Skillset.closePanel:
            // [0] = char_id, [1] = sessionKey, [2] = skills string (comma-separated)
            $charId     = isset($data[0]) ? (int)$data[0] : 0;
            $sessionKey = isset($data[1]) ? (string)$data[1] : '';
            $skillsStr  = isset($data[2]) ? (string)$data[2] : '';

            try {
                $account = validateSessionKey($sessionKey);
                if (!$account) {
                    throw new Exception('Invalid session');
                }

                if (trim($skillsStr) === '') {
                    $responseObj->status = 2; // client treat status>1 as notice
                    $responseObj->result = 'Equipped skill cannot empty';
                } else {
                    $db = getDBConnection();

                    // 1) Simpan ke kolom character_equipped_skills jika kolom ini ada
                    //    (gunakan UPDATE sederhana; jika kolom tidak ada, biarkan error ditangani try/catch)
                    try {
                        $stmtEq = $db->prepare("UPDATE characters SET character_equipped_skills = ? WHERE character_id = ? AND account_id = ?");
                        $stmtEq->execute(array($skillsStr, $charId, $account['account_id']));
                    } catch (Exception $eCol) {
                        // Abaikan jika kolom tidak ada; inventory JSON tetap menjadi sumber utama.
                    }

                    // 2) Perbarui juga JSON character_inventory.skillsets[0].skills
                    $stmt = $db->prepare("SELECT character_inventory FROM characters WHERE character_id = ? AND account_id = ? LIMIT 1");
                    $stmt->execute(array($charId, $account['account_id']));
                    $row = $stmt->fetch(PDO::FETCH_ASSOC);

                    $inv = array();
                    if ($row && !empty($row['character_inventory'])) {
                        $decoded = json_decode($row['character_inventory'], true);
                        if (is_array($decoded)) {
                            $inv = $decoded;
                        }
                    }

                    if (!isset($inv['skillsets']) || !is_array($inv['skillsets'])) {
                        $inv['skillsets'] = array();
                    }

                    if (empty($inv['skillsets'])) {
                        $inv['skillsets'][] = array('id' => 1, 'skills' => $skillsStr);
                    } else {
                        // Pastikan indeks 0 ada dan dalam bentuk array/object yang bisa kita tulis field skills-nya
                        if (is_array($inv['skillsets'][0])) {
                            $inv['skillsets'][0]['skills'] = $skillsStr;
                        } elseif (is_object($inv['skillsets'][0])) {
                            $inv['skillsets'][0]->skills = $skillsStr;
                        } else {
                            $inv['skillsets'][0] = array('id' => 1, 'skills' => $skillsStr);
                        }
                    }

                    $invJson = json_encode($inv);

                    $stmtUp = $db->prepare("UPDATE characters SET character_inventory = ? WHERE character_id = ? AND account_id = ?");
                    $stmtUp->execute(array($invJson, $charId, $account['account_id']));

                    $responseObj->status = 1;
                }

            } catch (Exception $e) {
                $responseObj->status = 0;
                $responseObj->error  = $e->getMessage();
            }

            file_put_contents(
                __DIR__ . "/debug_result.log",
                "SERVICE={$service} METHOD={$method}\n" . print_r($responseObj, true) . "\n",
                FILE_APPEND
            );

        } elseif ($method === 'getMissionRoomData') {

            // Payload dari MissionRoom.getMissionData:
            // [0] = char_id, [1] = sessionKey
            $charId     = isset($data[0]) ? (int)$data[0] : 0;
            $sessionKey = isset($data[1]) ? (string)$data[1] : '';

            try {
                $account = validateSessionKey($sessionKey);
                if (!$account) {
                    throw new Exception('Invalid session');
                }

                // Versi minimal: tidak ada recruit NPC & tidak pakai limit harian
                $responseObj->status  = 1;
                $responseObj->recruit = array();
                $responseObj->daily   = new stdClass();

            } catch (Exception $e) {
                $responseObj->status = 0;
                $responseObj->error  = $e->getMessage();
            }

            file_put_contents(
                __DIR__ . "/debug_result.log",
                "SERVICE={$service} METHOD={$method}\n" . print_r($responseObj, true) . "\n",
                FILE_APPEND
            );

        } elseif ($method === 'getSkillSets') {

            // Payload dari UI_Skillset.getSkillSets:
            // [0] = char_id, [1] = sessionKey
            $charId     = isset($data[0]) ? (int)$data[0] : 0;
            $sessionKey = isset($data[1]) ? (string)$data[1] : '';

            try {
                $account = validateSessionKey($sessionKey);
                if (!$account) {
                    throw new Exception('Invalid session');
                }

                $db = getDBConnection();

                $stmt = $db->prepare("
                    SELECT character_inventory
                    FROM characters
                    WHERE character_id = ? AND account_id = ?
                    LIMIT 1
                ");
                $stmt->execute(array($charId, $account['account_id']));
                $row = $stmt->fetch(PDO::FETCH_ASSOC);

                $skillsets = array();

                if ($row && !empty($row['character_inventory'])) {
                    $inv = json_decode($row['character_inventory'], true);
                    if (is_array($inv) && isset($inv['skillsets']) && is_array($inv['skillsets'])) {
                        foreach ($inv['skillsets'] as $i => $set) {
                            $id     = 0;
                            $skills = '';
                            if (is_array($set)) {
                                $id     = isset($set['id']) ? (int)$set['id'] : ($i + 1);
                                $skills = isset($set['skills']) ? (string)$set['skills'] : '';
                            } elseif (is_object($set)) {
                                $id     = isset($set->id) ? (int)$set->id : ($i + 1);
                                $skills = isset($set->skills) ? (string)$set->skills : '';
                            }
                            $obj         = new stdClass();
                            $obj->id     = $id;
                            $obj->skills = $skills;
                            $skillsets[] = $obj;
                        }
                    }
                }

                $responseObj->status    = 1;
                $responseObj->skillsets = $skillsets;

            } catch (Exception $e) {
                $responseObj->status = 0;
                $responseObj->error  = $e->getMessage();
            }

            file_put_contents(
                __DIR__ . "/debug_result.log",
                "SERVICE={$service} METHOD={$method}\n" . print_r($responseObj, true) . "\n",
                FILE_APPEND
            );

        } elseif ($method === 'saveSkillSet') {

            // Payload dari UI_Skillset.savePreset:
            // [0] = char_id, [1] = sessionKey, [2] = presetId, [3] = skills string
            $charId     = isset($data[0]) ? (int)$data[0] : 0;
            $sessionKey = isset($data[1]) ? (string)$data[1] : '';
            $presetId   = isset($data[2]) ? (int)$data[2] : 0;
            $skillsStr  = isset($data[3]) ? (string)$data[3] : '';

            try {
                $account = validateSessionKey($sessionKey);
                if (!$account) {
                    throw new Exception('Invalid session');
                }

                $db = getDBConnection();

                $stmt = $db->prepare("
                    SELECT character_inventory
                    FROM characters
                    WHERE character_id = ? AND account_id = ?
                    LIMIT 1
                ");
                $stmt->execute(array($charId, $account['account_id']));
                $row = $stmt->fetch(PDO::FETCH_ASSOC);

                $inv = array();
                if ($row && !empty($row['character_inventory'])) {
                    $decoded = json_decode($row['character_inventory'], true);
                    if (is_array($decoded)) {
                        $inv = $decoded;
                    }
                }

                if (!isset($inv['skillsets']) || !is_array($inv['skillsets'])) {
                    $inv['skillsets'] = array();
                }

                $updated = false;

                foreach ($inv['skillsets'] as $idx => &$set) {
                    $sid = 0;
                    if (is_array($set)) {
                        $sid = isset($set['id']) ? (int)$set['id'] : 0;
                    } elseif (is_object($set)) {
                        $sid = isset($set->id) ? (int)$set->id : 0;
                    }

                    if ($sid === $presetId) {
                        if (is_array($set)) {
                            $set['skills'] = $skillsStr;
                        } elseif (is_object($set)) {
                            $set->skills = $skillsStr;
                        }
                        $updated = true;
                        break;
                    }
                }
                unset($set);

                if (!$updated) {
                    $newSet           = array();
                    $newSet['id']     = $presetId;
                    $newSet['skills'] = $skillsStr;
                    $inv['skillsets'][] = $newSet;
                }

                $invJson = json_encode($inv);

                // Simpan keseluruhan inventory yang sudah berisi preset ke kolom JSON.
                // Tidak ada kolom "character_equipped_skills" di schema, jadi jangan di-SET di sini.
                $stmtUp = $db->prepare("
                    UPDATE characters
                    SET character_inventory = ?
                    WHERE character_id = ? AND account_id = ?
                ");
                $stmtUp->execute(array($invJson, $charId, $account['account_id']));

                // Bangun kembali array skillsets untuk dikirim ke client
                $skillsets = array();
                if (isset($inv['skillsets']) && is_array($inv['skillsets'])) {
                    foreach ($inv['skillsets'] as $i => $set) {
                        $obj         = new stdClass();
                        if (is_array($set)) {
                            $obj->id     = isset($set['id']) ? (int)$set['id'] : ($i + 1);
                            $obj->skills = isset($set['skills']) ? (string)$set['skills'] : '';
                        } elseif (is_object($set)) {
                            $obj->id     = isset($set->id) ? (int)$set->id : ($i + 1);
                            $obj->skills = isset($set->skills) ? (string)$set->skills : '';
                        } else {
                            $obj->id     = $i + 1;
                            $obj->skills = '';
                        }
                        $skillsets[] = $obj;
                    }
                }

                $responseObj->status    = 1;
                $responseObj->skillsets = $skillsets;

            } catch (Exception $e) {
                $responseObj->status = 0;
                $responseObj->error  = $e->getMessage();
            }

            file_put_contents(
                __DIR__ . "/debug_result.log",
                "SERVICE={$service} METHOD={$method}\n" . print_r($responseObj, true) . "\n",
                FILE_APPEND
            );

        } elseif ($method === 'createSkillSet') {

            // Payload dari UI_Skillset.addPreset:
            // [0] = char_id, [1] = sessionKey
            $charId     = isset($data[0]) ? (int)$data[0] : 0;
            $sessionKey = isset($data[1]) ? (string)$data[1] : '';

            try {
                $account = validateSessionKey($sessionKey);
                if (!$account) {
                    throw new Exception('Invalid session');
                }

                $db = getDBConnection();

                $stmt = $db->prepare("
                    SELECT character_inventory
                    FROM characters
                    WHERE character_id = ? AND account_id = ?
                    LIMIT 1
                ");
                $stmt->execute(array($charId, $account['account_id']));
                $row = $stmt->fetch(PDO::FETCH_ASSOC);

                $inv = array();
                if ($row && !empty($row['character_inventory'])) {
                    $decoded = json_decode($row['character_inventory'], true);
                    if (is_array($decoded)) {
                        $inv = $decoded;
                    }
                }

                if (!isset($inv['skillsets']) || !is_array($inv['skillsets'])) {
                    $inv['skillsets'] = array();
                }

                // Maksimal 4 preset seperti di client
                if (count($inv['skillsets']) >= 4) {
                    $responseObj->status = 0;
                    $responseObj->result = 'Maximum preset reached';
                } else {
                    // Tentukan id baru berdasarkan id terbesar yang ada
                    $maxId = 0;
                    foreach ($inv['skillsets'] as $set) {
                        if (is_array($set) && isset($set['id'])) {
                            $sid = (int)$set['id'];
                        } elseif (is_object($set) && isset($set->id)) {
                            $sid = (int)$set->id;
                        } else {
                            $sid = 0;
                        }
                        if ($sid > $maxId) {
                            $maxId = $sid;
                        }
                    }
                    $newId = $maxId + 1;
                    if ($newId < 1) {
                        $newId = 1;
                    }

                    $newSet           = array();
                    $newSet['id']     = $newId;
                    $newSet['skills'] = '';
                    $inv['skillsets'][] = $newSet;

                    $invJson = json_encode($inv);

                    $stmtUp = $db->prepare("
                        UPDATE characters
                        SET character_inventory = ?
                        WHERE character_id = ? AND account_id = ?
                    ");
                    $stmtUp->execute(array($invJson, $charId, $account['account_id']));

                    // Kembalikan semua preset ke client
                    $skillsets = array();
                    foreach ($inv['skillsets'] as $i => $set) {
                        $obj         = new stdClass();
                        if (is_array($set)) {
                            $obj->id     = isset($set['id']) ? (int)$set['id'] : ($i + 1);
                            $obj->skills = isset($set['skills']) ? (string)$set['skills'] : '';
                        } elseif (is_object($set)) {
                            $obj->id     = isset($set->id) ? (int)$set->id : ($i + 1);
                            $obj->skills = isset($set->skills) ? (string)$set->skills : '';
                        } else {
                            $obj->id     = $i + 1;
                            $obj->skills = '';
                        }
                        $skillsets[] = $obj;
                    }

                    $responseObj->status    = 1;
                    $responseObj->skillsets = $skillsets;
                }

            } catch (Exception $e) {
                $responseObj->status = 0;
                $responseObj->error  = $e->getMessage();
            }

            file_put_contents(
                __DIR__ . "/debug_result.log",
                "SERVICE={$service} METHOD={$method}\n" . print_r($responseObj, true) . "\n",
                FILE_APPEND
            );

        } elseif ($method === 'removeRecruitments') {

            // Payload dari MissionRoom.removeRecruitedSquad:
            // [0] = char_id, [1] = sessionKey
            $charId     = isset($data[0]) ? (int)$data[0] : 0;
            $sessionKey = isset($data[1]) ? (string)$data[1] : '';

            try {
                $account = validateSessionKey($sessionKey);
                if (!$account) {
                    throw new Exception('Invalid session');
                }

                // Versi minimal: tidak ada recruit yang disimpan di server
                $responseObj->status = 1;

            } catch (Exception $e) {
                $responseObj->status = 0;
                $responseObj->error  = $e->getMessage();
            }

            file_put_contents(
                __DIR__ . "/debug_result.log",
                "SERVICE={$service} METHOD={$method}\n" . print_r($responseObj, true) . "\n",
                FILE_APPEND
            );

        } elseif ($method === 'buySkill') {

            // Payload dari Academy.learnSkill (Academy.as):
            // this.main.amf_manager.service("CharacterService.buySkill",
            //     [Character.sessionkey, Character.char_id, this.selected_skill_id], ...)
            // Jadi urutannya:
            // [0] = sessionKey, [1] = char_id, [2] = skillId
            $sessionKey = isset($data[0]) ? (string)$data[0] : '';
            $charId     = isset($data[1]) ? (int)$data[1] : 0;
            $skillId    = isset($data[2]) ? (string)$data[2] : '';

            try {
                $account = validateSessionKey($sessionKey);
                if (!$account) {
                    throw new Exception('Invalid session');
                }

                if ($skillId === '') {
                    throw new Exception('Invalid skill');
                }

                $db = getDBConnection();

                // Pastikan karakter milik akun yang benar dan ambil juga atribut elemen
                $stmtChar = $db->prepare("
                    SELECT character_id, character_gold, character_token, character_inventory,
                           character_wind, character_fire, character_lightning,
                           character_water, character_earth
                    FROM characters
                    WHERE character_id = ? AND account_id = ?
                    LIMIT 1
                ");
                $stmtChar->execute(array($charId, $account['account_id']));
                $charRow = $stmtChar->fetch(PDO::FETCH_ASSOC);
                if (!$charRow) {
                    throw new Exception('Character not found');
                }

                // Cek apakah skill sudah dimiliki di tabel skills
                $stmtCheck = $db->prepare("
                    SELECT skill_id
                    FROM skills
                    WHERE character_id = ? AND skill_code = ?
                    LIMIT 1
                ");
                $stmtCheck->execute(array($charId, $skillId));
                $exists = $stmtCheck->fetch(PDO::FETCH_ASSOC);

                if ($exists) {
                    // Sudah punya skill, cukup kembalikan status sukses supaya UI tidak error
                    $responseObj->status = 1;

                } else {
                    // Tambahkan record skill baru ke tabel skills
                    $stmtIns = $db->prepare("
                        INSERT INTO skills (character_id, skill_code, skill_level, skill_type)
                        VALUES (?, ?, 1, NULL)
                    ");
                    $stmtIns->execute(array($charId, $skillId));

                    // Update JSON character_inventory.char_skills agar konsisten dengan client lama
                    $invArr = array();
                    if (!empty($charRow['character_inventory'])) {
                        $decoded = json_decode($charRow['character_inventory'], true);
                        if (is_array($decoded)) {
                            $invArr = $decoded;
                        }
                    }

                    $current = isset($invArr['char_skills']) ? (string)$invArr['char_skills'] : '';
                    $list    = array();
                    if ($current !== '') {
                        $list = explode(',', $current);
                    }

                    if (!in_array($skillId, $list, true)) {
                        $list[] = $skillId;
                    }

                    // Bersihkan entri kosong dan simpan lagi sebagai string
                    $list = array_filter($list, function ($v) {
                        return $v !== '';
                    });
                    $invArr['char_skills'] = implode(',', $list);

                    $invJson = json_encode($invArr);

                    // Untuk saat ini, tidak mengurangi gold/token di DB agar aman untuk testing.
                    $stmtUp = $db->prepare("
                        UPDATE characters
                        SET character_inventory = ?
                        WHERE character_id = ? AND account_id = ?
                    ");
                    $stmtUp->execute(array($invJson, $charId, $account['account_id']));

                    $responseObj->status = 1;
                }

                // Bangun blok data untuk Academy.buyResponse
                if ($responseObj->status === 1) {
                    $dataObj = new stdClass();
                    $dataObj->character_gold = isset($charRow['character_gold'])  ? (int)$charRow['character_gold']  : 0;
                    $dataObj->account_tokens = isset($charRow['character_token']) ? (int)$charRow['character_token'] : 0;

                    // Derive element indexes dari atribut elemen di tabel characters
                    $elements  = array();
                    $elemStats = array(
                        1 => isset($charRow['character_wind'])      ? (int)$charRow['character_wind']      : 0,
                        2 => isset($charRow['character_fire'])      ? (int)$charRow['character_fire']      : 0,
                        3 => isset($charRow['character_lightning']) ? (int)$charRow['character_lightning'] : 0,
                        4 => isset($charRow['character_earth'])     ? (int)$charRow['character_earth']     : 0,
                        5 => isset($charRow['character_water'])     ? (int)$charRow['character_water']     : 0,
                    );

                    foreach ($elemStats as $idx => $val) {
                        if ($val > 0) {
                            $elements[] = $idx;
                        }
                    }

                    $dataObj->character_element_1 = isset($elements[0]) ? $elements[0] : 0;
                    $dataObj->character_element_2 = isset($elements[1]) ? $elements[1] : 0;
                    $dataObj->character_element_3 = isset($elements[2]) ? $elements[2] : 0;

                    $responseObj->data = $dataObj;
                }

            } catch (Exception $e) {
                $responseObj->status = 0;
                $responseObj->error  = $e->getMessage();
            }

            file_put_contents(
                __DIR__ . "/debug_result.log",
                "SERVICE={$service} METHOD={$method}\n" . print_r($responseObj, true) . "\n",
                FILE_APPEND
            );

        } elseif ($method === 'buyItem') {

            // Payload dari BaseShop.buyItemAmf:
            // [0] = char_id, [1] = sessionKey, [2] = itemId, [3] = quantity
            $charId     = isset($data[0]) ? (int)$data[0] : 0;
            $sessionKey = isset($data[1]) ? (string)$data[1] : '';
            $itemId     = isset($data[2]) ? (string)$data[2] : '';
            $quantity   = isset($data[3]) ? (int)$data[3] : 1;
            if ($quantity < 1) {
                $quantity = 1;
            }

            try {
                $account = validateSessionKey($sessionKey);
                if (!$account) {
                    throw new Exception('Invalid session');
                }

                $db = getDBConnection();

                // Ambil inventory karakter saat ini
                $stmt = $db->prepare("
                    SELECT character_inventory
                    FROM characters
                    WHERE character_id = ? AND account_id = ?
                    LIMIT 1
                ");
                $stmt->execute(array($charId, $account['account_id']));
                $row = $stmt->fetch(PDO::FETCH_ASSOC);
                if (!$row) {
                    throw new Exception('Character not found');
                }

                $invArr = array();
                if (!empty($row['character_inventory'])) {
                    $decoded = json_decode($row['character_inventory'], true);
                    if (is_array($decoded)) {
                        $invArr = $decoded;
                    }
                }

                // Tentukan field inventory berdasarkan prefix ID item
                $parts  = explode('_', $itemId);
                $prefix = isset($parts[0]) ? $parts[0] : '';
                $field  = 'char_items';
                switch ($prefix) {
                    case 'wpn':
                        $field = 'char_weapons';
                        break;
                    case 'back':
                        $field = 'char_back_items';
                        break;
                    case 'accessory':
                        $field = 'char_accessories';
                        break;
                    case 'set':
                        $field = 'char_sets';
                        break;
                    case 'hair':
                        $field = 'char_hairs';
                        break;
                    case 'material':
                        $field = 'char_materials';
                        break;
                    case 'essential':
                        $field = 'char_essentials';
                        break;
                    case 'skill':
                        $field = 'char_skills';
                        break;
                    default:
                        $field = 'char_items';
                        break;
                }

                $current = isset($invArr[$field]) ? (string)$invArr[$field] : '';
                $items   = array();
                if ($current !== '') {
                    $items = explode(',', $current);
                }

                $found = false;
                for ($i = 0; $i < count($items); $i++) {
                    if ($items[$i] === '') {
                        continue;
                    }
                    $pair = explode(':', $items[$i]);
                    $id   = $pair[0];
                    $qty  = isset($pair[1]) ? (int)$pair[1] : 1;
                    if ($id === $itemId) {
                        $qty       += $quantity;
                        $items[$i] = $id . ':' . $qty;
                        $found     = true;
                        break;
                    }
                }

                if (!$found) {
                    $items[] = $itemId . ':' . $quantity;
                }

                // Bersihkan item kosong dan susun kembali string inventory
                $items = array_filter($items, function ($v) {
                    return $v !== '';
                });
                $invArr[$field] = implode(',', $items);

                $invJson = json_encode($invArr);

                $stmtUp = $db->prepare("
                    UPDATE characters
                    SET character_inventory = ?
                    WHERE character_id = ? AND account_id = ?
                ");
                $stmtUp->execute(array($invJson, $charId, $account['account_id']));

                // Untuk saat ini, server tidak mengurangi gold / token di DB.
                // Client sudah mengurangi secara lokal untuk tampilan.
                $responseObj->status = 1;

            } catch (Exception $e) {
                $responseObj->status = 0;
                $responseObj->error  = $e->getMessage();
            }

            file_put_contents(
                __DIR__ . "/debug_result.log",
                "SERVICE={$service} METHOD={$method}\n" . print_r($responseObj, true) . "\n",
                FILE_APPEND
            );

        } else {

            // Method CharacterService lain belum diimplementasikan
            $responseObj->status = 0;
            $responseObj->error  = 'Unknown CharacterService method';

            file_put_contents(
                __DIR__ . "/debug_result.log",
                "SERVICE={$service} METHOD={$method}\n" . print_r($responseObj, true) . "\n",
                FILE_APPEND
            );
        }

    } else {

        $gateway = new Gateway();
        $result = $gateway->callService($service, $method, $data);

        if ($service === 'SystemService' && $method === 'login') {
            // $result adalah array yang dikembalikan SystemService::login()
            $loginData    = $result;
            $accountArray = isset($loginData['account']) ? $loginData['account'] : array(0, 0, 0, '');

            // Format yang diharapkan LoginMenu / Account.setupAccount
            $responseObj->status    = '1';
            $responseObj->result    = $accountArray;
            $responseObj->signature = ns_generate_login_signature($accountArray);

            // Field tambahan yang dicek LoginMenu / NinjaSaga.as
            $responseObj->account_lock               = isset($loginData['account_lock']) ? $loginData['account_lock'] : null;
            $responseObj->swf_versions               = isset($loginData['swf_versions']) ? $loginData['swf_versions'] : array();
            $responseObj->account_registered_tutored = isset($loginData['is_new_account']) ? $loginData['is_new_account'] : 0;
            $responseObj->account_registered_password = 1;

            // Log final object yang DIKIRIM ke Flash
            file_put_contents(
                __DIR__ . "/debug_result.log",
                "SERVICE={$service} METHOD={$method}\n" . print_r($responseObj, true) . "\n",
                FILE_APPEND
            );

        } elseif ($service === 'CharacterDAO' && $method === 'getCharactersList') {

            // $result = array of associative arrays dari CharacterDAO::getCharactersList
            $list = array();
            if (is_array($result)) {
                foreach ($result as $row) {
                    $id     = isset($row['character_id'])    ? (int)$row['character_id']    : 0;
                    $name   = isset($row['character_name'])  ? (string)$row['character_name'] : '';
                    $level  = isset($row['character_level']) ? (int)$row['character_level'] : 1;
                    $gender = isset($row['character_gender'])? (int)$row['character_gender'] : 0;

                    // Bentuk array [id, name, level, gender]
                    $list[] = array($id, $name, $level, $gender);
                }
            }

            $responseObj->status = 1;
            $responseObj->result = $list;
            $responseObj->login_per_day = 0;

            file_put_contents(
                __DIR__ . "/debug_result.log",
                "SERVICE={$service} METHOD={$method}\n" . print_r($responseObj, true) . "\n",
                FILE_APPEND
            );

        } elseif ($service === 'PetService') {

            // Pet panels (Pets.as, PetInventory.as, PetVilla.as) expect
            // top-level fields: status, pets, slots, etc.
            // Gateway::callService() already returns a stdClass with these
            // fields, so cukup "unwrap" ke responseObj.
            if (is_object($result)) {
                $responseObj = $result;
            } else {
                $responseObj->status = 0;
                $responseObj->error  = 'Invalid PetService response';
            }

            file_put_contents(
                __DIR__ . "/debug_result.log",
                "SERVICE={$service} METHOD={$method}\n" . print_r($responseObj, true) . "\n",
                FILE_APPEND
            );

        } elseif ($service === 'BattleSystem') {

            // BattleSystem has mixed return types:
            // - startMission: client expects a raw 10-char battle code (string)
            // - other methods: client expects an object with fields like
            //   status/xp/level/result/etc. (no extra wrapping under result).
            if ($method === 'startMission') {
                // Pass through the raw value (string/array) directly.
                $responseObj = $result;
            } else {
                if (is_object($result)) {
                    $responseObj = $result;
                } else {
                    $responseObj->status = 0;
                    $responseObj->error  = 'Invalid BattleSystem response';
                }
            }

            file_put_contents(
                __DIR__ . "/debug_result.log",
                "SERVICE={$service} METHOD={$method}\n" . print_r($responseObj, true) . "\n",
                FILE_APPEND
            );

        } else {
            $responseObj->status = 1;
            $responseObj->result = $result;
            file_put_contents(
                __DIR__ . "/debug_result.log",
                "SERVICE={$service} METHOD={$method}\n" . print_r($responseObj, true) . "\n",
                FILE_APPEND
            );
        }
    }

    $resp = new SabreAMF_Message();

// Pakai encoding yang sama dengan request (AMF0 / AMF3)
$resp->setEncoding($msg->getEncoding());

// AMF: 'target' = "/1/onResult", 'response' = "" (kosong)
$resp->addBody(array(
    'target'   => $response . '/onResult',
    'response' => '',
    'data'     => $responseObj,
));

  file_put_contents(__DIR__ . "/debug_trace.log",
    "BEFORE SERIALIZE\n",
    FILE_APPEND
);

$out = new SabreAMF_OutputStream();
$resp->serialize($out);

file_put_contents(__DIR__ . "/debug_trace.log",
    "AFTER SERIALIZE\n",
    FILE_APPEND
);

header("Content-Type: application/x-amf");
echo $out->getRawData();

file_put_contents(__DIR__ . "/debug_trace.log",
    "AFTER ECHO\n",
    FILE_APPEND
);
    exit;

} catch (Exception $e) {
    // Log detail exception supaya kelihatan kalau deserialisasi/handler gagal
    file_put_contents(__DIR__ . "/debug_trace.log",
        "EXCEPTION: " . $e->getMessage() . "\n" . $e->getTraceAsString() . "\n",
        FILE_APPEND
    );
    error_log($e->getMessage());
    sendError($e->getMessage());
}
