<?php
/**
 * SystemService - Handle system operations
 */

class SystemService {
    private $db;
    
    public function __construct($db) {
        $this->db = $db;
    }
    
    /**
     * Login dengan username dan password
     * SystemService.login(username, password, build_no)
     */
    public function login($username, $password, $buildNo) {
        $stmt = $this->db->prepare("
            SELECT account_id, username, password, account_type, 
                   is_new_account, promote_id, country_area
            FROM accounts 
            WHERE username = ?
        ");
        $stmt->execute([$username]);
        $account = $stmt->fetch();
        
        if (!$account) {
            throw new Exception("Invalid username or password");
        }
        
        // Check password (MD5 for now)
        if (md5($password) !== $account['password']) {
            throw new Exception("Invalid username or password");
        }
        
        // Generate session key
        $sessionKey = generateSessionKey($account['account_id'], $account['username']);
        $expireTime = date('Y-m-d H:i:s', time() + SESSION_EXPIRE);
        
        // Update session
        $stmt = $this->db->prepare("
            UPDATE accounts 
            SET session_key = ?, session_expire = ? 
            WHERE account_id = ?
        ");
        $stmt->execute([$sessionKey, $expireTime, $account['account_id']]);
        
        // Get characters list
        $stmt = $this->db->prepare("
            SELECT character_id, character_name, character_level, character_xp,
                   character_hp, character_max_hp, character_cp, character_max_cp,
                   character_gold, character_rank
            FROM characters 
            WHERE account_id = ?
        ");
        $stmt->execute([$account['account_id']]);
        $characters = $stmt->fetchAll();
        
        // Get system data
        $stmt = $this->db->prepare("SELECT data_value FROM system_data WHERE data_key = 'swf_versions'");
        $stmt->execute();
        $swfVersions = json_decode($stmt->fetchColumn(), true);
        
        return [
            $sessionKey, // session_key
            $characters, // characters array
            $swfVersions, // swf_versions
            $account['is_new_account'], // is_new_account
            $account['promote_id'], // promote_id
            $account['country_area'], // country_area
            null, // account_lock (null = no lock)
            0, // is_trial_emblem
            0, // is_expired
            $account['account_type'] == 1 ? 1 : 0, // is_premium
        ];
    }
    
    /**
     * SNS Login (Facebook, etc.)
     * SystemService.snsLogin(uid, type, build_no, ...)
     */
    public function snsLogin($uid, $type, $buildNo, $hash = '', $signature = '', $accessToken = '', $lang = 'en') {
        // For now, create or get account by UID
        $stmt = $this->db->prepare("
            SELECT account_id, username, account_type, is_new_account, promote_id, country_area
            FROM accounts 
            WHERE username = ? OR access_token = ?
        ");
        $stmt->execute([$uid, $uid]);
        $account = $stmt->fetch();
        
        if (!$account) {
            // Create new account
            $stmt = $this->db->prepare("
                INSERT INTO accounts (username, password, account_type, access_token, is_new_account)
                VALUES (?, ?, 0, ?, 1)
            ");
            $stmt->execute([$uid, md5($uid . APP_SECRET), $accessToken]);
            $accountId = $this->db->lastInsertId();
            
            $account = [
                'account_id' => $accountId,
                'username' => $uid,
                'account_type' => 0,
                'is_new_account' => 1,
                'promote_id' => null,
                'country_area' => null,
            ];
        }
        
        // Generate session key
        $sessionKey = generateSessionKey($account['account_id'], $account['username']);
        $expireTime = date('Y-m-d H:i:s', time() + SESSION_EXPIRE);
        
        // Update session
        $stmt = $this->db->prepare("
            UPDATE accounts 
            SET session_key = ?, session_expire = ?, access_token = ?
            WHERE account_id = ?
        ");
        $stmt->execute([$sessionKey, $expireTime, $accessToken, $account['account_id']]);
        
        // Get characters
        $stmt = $this->db->prepare("
            SELECT character_id, character_name, character_level, character_xp,
                   character_hp, character_max_hp, character_cp, character_max_cp,
                   character_gold, character_rank
            FROM characters 
            WHERE account_id = ?
        ");
        $stmt->execute([$account['account_id']]);
        $characters = $stmt->fetchAll();
        
        // Get system data
        $stmt = $this->db->prepare("SELECT data_value FROM system_data WHERE data_key = 'swf_versions'");
        $stmt->execute();
        $swfVersions = json_decode($stmt->fetchColumn(), true);
        
        return [
            $sessionKey,
            $characters,
            $swfVersions,
            $account['is_new_account'],
            $account['promote_id'],
            $account['country_area'],
            null, // account_lock
            0, // is_trial_emblem
            0, // is_expired
        ];
    }
    
    /**
     * Require login (for SNS)
     * SystemService.requireLogin(time, hash_time, uid)
     */
    public function requireLogin($time, $hashTime, $uid) {
        // Generate temporary token
        $token = md5($time . $hashTime . $uid . APP_SECRET);
        return $token;
    }
}

