<?php
/**
 * SystemData - Handle system data operations
 */

class SystemData {
    private $db;
    
    public function __construct($db) {
        $this->db = $db;
    }
    
    /**
     * Get system data
     * SystemData.get(session_key, test_version)
     */
    public function get($sessionKey, $testVersion = false) {
        $account = validateSessionKey($sessionKey);
        if (!$account) {
            throw new Exception("Invalid session");
        }
        
        // Get all system data
        $stmt = $this->db->prepare("SELECT data_key, data_value, data_type FROM system_data");
        $stmt->execute();
        $systemData = [];
        
        while ($row = $stmt->fetch()) {
            $key = $row['data_key'];
            $value = $row['data_value'];
            
            if ($row['data_type'] === 'json') {
                $systemData[$key] = json_decode($value, true);
            } else {
                $systemData[$key] = $value;
            }
        }
        
        // Get character data
        $stmt = $this->db->prepare("
            SELECT character_id, character_level, character_xp,
                   character_hp, character_max_hp, character_cp, character_max_cp,
                   character_gold, character_token, character_rank
            FROM characters 
            WHERE account_id = ? 
            ORDER BY character_id ASC 
            LIMIT 1
        ");
        $stmt->execute([$account['account_id']]);
        $character = $stmt->fetch();
        
        return array(
            'swf_versions' => isset($systemData['swf_versions']) ? $systemData['swf_versions'] : array(),
            'build_no' => isset($systemData['build_no']) ? $systemData['build_no'] : BUILD_NO,
            'data_version' => isset($systemData['data_version']) ? $systemData['data_version'] : '1.0',
            'admin_message' => isset($systemData['admin_message']) ? $systemData['admin_message'] : '',
            'character' => $character
        );
    }
}
